% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{freqs}
\alias{freqs}
\title{Multiple Univariate Frequency Tables}
\usage{
freqs(data, vrb.nm, prop = FALSE, useNA = "always", total = "no")
}
\arguments{
\item{data}{data.fame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{prop}{logical vector of length 1 specifying whether the frequencies
should be counts (FALSE) or proportions (TRUE). Note, whether the
proportions include missing values depends on the \code{useNA} argument.}

\item{useNA}{character vector of length 1 specifying how missing values
should be handled. The three options are 1) "no" = do not include NA
frequencies in the return object, 2) "ifany" = only NA frequencies if there
are any missing values (in any variable from \code{data[vrb.nm]}), or 3)
"always" = do include NA frequencies regardless of whether there are
missing values or not.}

\item{total}{character vector of length 1 specifying whether the frequencies
for the set of variables as a whole should be returned. The name "total"
refers to tabulating the frequencies for the variables from
\code{data[vrb.nm]} together as a set. The three options are 1) "no" = do
not include a row for the total frequencies in the return object, 2) "yes"
= do include the total frequencies as the first row in the return object,
or 3) "only" = only include the total frequencies as a single row in the
return object and do not include rows for each of the individual column
frequencies in \code{data[vrb.nm]}.}
}
\value{
data.frame of frequencies for the variables in \code{data[vrb.nm]}.
  Depending on \code{prop}, the frequencies are either counts (FALSE) or
  proportions (TRUE). Depending on \code{total}, the nrow is either 1)
  \code{length(vrb.nm)} (if \code{total} = "no"), 1 + \code{length(vrb.nm)}
  (if \code{total} = "yes"), or 3) 1 (if \code{total} = "only"). The rownames
  are \code{vrb.nm} for each variable in \code{data[vrb.nm]} and "_total_"
  for the total row (if present). The colnames are the unique values present
  in \code{data[vrb.nm]}, potentially including "(NA)" depending on
  \code{useNA}.
}
\description{
\code{freqs} creates a frequency table for a set of variables in a
data.frame. Depending on \code{total}, frequencies for all the variables
together can be returned. The function probably makes the most sense for sets
of variables with similar unique values (e.g., items from a questionnaire
with similar response options).
}
\details{
\code{freqs} uses \code{plyr::rbind.fill} to combine the results from
\code{table} applied to each variable into a single data.frame. If a variable
from \code{data[vrb.nm]} does not have values present in other variables from
\code{data[vrb.nm]}, then the frequencies in the return object will be 0.

The name for the table element giving the frequency of missing values is
"(NA)". This is different from \code{table} where the name is
\code{NA_character_}. This change allows for the sorting of tables that
include missing values, as subsetting in R is not possible with
\code{NA_character_} names. In future versions of the package, this might
change as it should be possible to avoid this issue by subetting with a
logical vector or integer indices instead of names. However, it is convenient
to be able to subset the return object fully by names.
}
\examples{
vrb_nm <- str2str::inbtw(names(psych::bfi), "A1","O5")
freqs(data = psych::bfi, vrb.nm = vrb_nm) # default
freqs(data = psych::bfi, vrb.nm = vrb_nm, prop = TRUE) # proportions by row
freqs(data = psych::bfi, vrb.nm = vrb_nm, useNA = "no") # without NA counts
freqs(data = psych::bfi, vrb.nm = vrb_nm, total = "yes") # include total counts
}
\seealso{
\code{\link{freq}}
   \code{\link{freqs_by}}
   \code{\link{freq_by}}
   \code{\link{table}}
}
