% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metrics.R
\name{plot_metrics}
\alias{plot_metrics}
\title{Plot metrics generated from the "calculate" family of quicR functions.}
\usage{
plot_metrics(
  data,
  sample_col = "Sample IDs",
  fill = "Dilutions",
  dilution_bool = TRUE,
  nrow = 2,
  ncol = 2
)
}
\arguments{
\item{data}{A dataframe containing the calculated metrics from the "calculate" family of quicR functions.}

\item{sample_col}{The name of the column containing the sample IDs.}

\item{fill}{The column containing the fill aesthetic. Usually the dilutions column.}

\item{dilution_bool}{Logical; should dilution factors be included in the plot?}

\item{nrow}{Integer; number of rows to output in the plot.}

\item{ncol}{Integer; number of columns to output in the plot.}
}
\value{
A ggplot object
}
\description{
Generates a faceted figure of boxplots.
}
\examples{
# This test takes >5 sec
\donttest{
file <- system.file(
  "extdata/input_files",
  file = "test4.xlsx",
  package = "quicR"
)

data <- quicR::get_real(file)[[1]] |>
  quicR::normalize_RFU()

meta <- quicR::organize_tables(file) |>
  quicR::convert_tables()

calculate_metrics(data, meta) |>
  plot_metrics()
}

}
