% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraryAll.R
\name{libraryAll}
\alias{libraryAll}
\title{Load specific R libraries and clear environment}
\usage{
libraryAll(..., lib.loc = NULL, quietly = FALSE, clear = TRUE)
}
\arguments{
\item{...}{multiple library names}

\item{lib.loc}{OPTIONAL. library store location}

\item{quietly}{OPTIONAL. attach library quietly}

\item{clear}{OPTIONAL. clear environment after attach}
}
\value{
loaded libraries and clear environment
}
\description{
Only include libraries, don't install if library doesn't exist
}
\examples{
\donttest{
libraryAll(r2resize) #one package

libraryAll(
  r2symbols,
  dplyr,
  ggplot2,
  shinyStorePlus
) #multiple packages

libraryAll("r2ymbols") #with quotes

libraryAll(
  xml2,
  mrgsolve,
  quietly = TRUE
) #load quietly

libraryAll(
  nextGenShinyApps,
clear = FALSE) #do not clear console after load

}
}
