% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/how_similar.R
\name{percent_match}
\alias{percent_match}
\alias{\%match\%}
\alias{sound_match}
\title{Function to calculate the percentage of matching between two strings}
\usage{
percent_match(
  string1,
  string2,
  case_sensitive = FALSE,
  ignore_whitespace = TRUE,
  frag_size = 2
)

string1 \%match\% string2

sound_match(string1, string2)
}
\arguments{
\item{string1}{first string}

\item{string2}{second string}

\item{case_sensitive}{if to check case sensitivity}

\item{ignore_whitespace}{if to ignore whitespace}

\item{frag_size}{fragment size of string}
}
\value{
numeric value of the match percent

match word sounds
}
\description{
Function to calculate the percentage of matching between two strings
}
\details{
Case Sensitivity: \cr

  The function can optionally consider or ignore case sensitivity based on the \code{case_sensitive} argument.\cr\cr
Whitespace Handling:\cr

  With \code{ignore_whitespace} set to TRUE, the function removes all whitespaces before comparison. This can be useful for matching strings that may have inconsistent spacing.\cr\cr
Exact Character-by-Character Matching:\cr

  The function computes the percentage of matching characters in the same positions.\cr\cr
Substring Matching:\cr

  The function checks if one string is a substring of the other, awarding a full match if true.\cr\cr
Levenshtein Distance:\cr

  The function uses Levenshtein distance to calculate the similarity and integrates this into the overall match percentage.\cr\cr
Fragment Matching:\cr

   - A \code{frag_size} argument is introduced that compares fragments (substrings) of a given size (default is 3) from both strings.\cr
 - The function creates unique fragments from each string and compares them to find common fragments.\cr
 - The percentage match is calculated based on the ratio of common fragments to the total number of unique fragments.\cr\cr
Combining Metrics:\cr

  The overall match percentage is computed as the average of exact match, substring match, Levenshtein match, and fragment match percentages.
}
\examples{
# Example 1: simple match
string1 <- "Hello World"
string2 <- "helo world"

match_percent <- percent_match(string1, string2)
message("Percentage of matching: ", match_percent)


# Example 2: which date is closest
string0 <- "october 12,1898"
string1 <- "2018-10-12"
string2 <- "1898-10-12"
percent_match(string0, string1)
percent_match(string0, string2)
percent_match(string0, string2, frag_size = 4)
percent_match(string1, string2)

sound_match("Robert","rupert")
sound_match("rupert","Rubin")
sound_match("book","oops")
}
