% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.InteractionClassification.R
\name{summary.InteractionClassification}
\alias{summary.InteractionClassification}
\title{Summarize Interaction Classification Results}
\usage{
\method{summary}{InteractionClassification}(object, ...)
}
\arguments{
\item{object}{An object of class \code{InteractionClassification} containing
the classified data and clustering results.}

\item{...}{Additional arguments passed to other methods (currently not used).}
}
\value{
A data frame summarizing the mean viral load differences and CD4
count differences for each classification, along with the count
of observations in each classification.
}
\description{
This function calculates and summarizes the mean viral load differences
and CD4 count differences for each classification in the Interaction
Classification object.
}
\examples{
data(vl_3)
data(cd_3)
interaction_obj <- create_interactions(cd_3[,-1], vl_3[,-1])
class_obj <- InteractionClassification(interaction_obj$vlogs_diff, interaction_obj$cds_diff)
summary(class_obj)
}
