% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_se.R
\name{mean_se}
\alias{mean_se}
\title{Mean and Standard Error (of the mean)}
\usage{
mean_se(
  x,
  digits = getOption("qwraps2_frmt_digits", 2),
  na_rm = FALSE,
  show_n = "ifNA",
  denote_sd = "pm",
  markup = getOption("qwraps2_markup", "latex"),
  ...
)
}
\arguments{
\item{x}{a numeric vector}

\item{digits}{digits to the right of the decimal point to return in the
percentage estimate.}

\item{na_rm}{if true, omit NA values}

\item{show_n}{defaults to "ifNA".  Other options are "always" or "never".}

\item{denote_sd}{a character string set to either "pm" or "paren" for reporting 'mean
\eqn{\pm} sd' or 'mean (sd)'}

\item{markup}{latex or markdown}

\item{...}{pass through}
}
\value{
a character vector of the formatted values
}
\description{
A function for calculating and formatting means and
standard deviations.
}
\details{
Given a numeric vector, \code{mean_se} will return a character string with
the mean and standard error of the mean.  Formatting of the output will be
extended in future versions.
}
\examples{
set.seed(42)
x <- rnorm(1000, 3, 4)
mean(x)
sd(x) / sqrt(length(x)) # standard error
mean_se(x)
mean_se(x, show_n = "always")
mean_se(x, show_n = "always", denote_sd = "paren")

x[187] <- NA
mean_se(x, na_rm = TRUE)

}
