% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetted.R
\name{languageStartsWith}
\alias{languageStartsWith}
\title{Fetch countries data based on official language prefix}
\usage{
languageStartsWith(char, full.list = TRUE)
}
\arguments{
\item{char}{character to search in languages}

\item{full.list}{whether to return only name of country or full list}
}
\value{
language list or country data list matching parts of a character search on languages
}
\description{
Obtain country data matching language first one or more letters
}
\examples{
# task 1: get only language names that ends with "EN" or "en"
# note that the search in case-insensitive
languageStartsWith("eN", full.list = FALSE)

# task 2: get only language names that ends with "chi"
languageStartsWith("chi", full.list = FALSE)

# task 3: repeat task 2, but return full list for each country with the language
languageStartsWith("sin", full.list = TRUE)

# searching text with no results
languageStartsWith("er", full.list = FALSE)

}
\seealso{
\code{\link{countryStartsWith}} for country search starting with specified characters, and [countryEndsWith()] for countries that end with a specified characters.
}
