/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.clustering;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.ValueUtil;

public class ClusteringModelUtil {
    private ClusteringModelUtil() {
    }

    public static List<ClusteringField> createClusteringFields(List<? extends Feature> features) {
        return ClusteringModelUtil.createClusteringFields(features, null);
    }

    public static List<ClusteringField> createClusteringFields(List<? extends Feature> features, List<Number> weights) {
        if (weights != null && features.size() != weights.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<ClusteringField> clusteringFields = new ArrayList<ClusteringField>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number weight = weights != null ? (Number)weights.get(i) : (Number)null;
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            ClusteringField clusteringField = new ClusteringField(continuousFeature.getName());
            if (weight != null && !ValueUtil.isOne(weight)) {
                clusteringField.setFieldWeight(ValueUtil.asDouble(weight));
            }
            clusteringFields.add(clusteringField);
        }
        return clusteringFields;
    }

    public static Output createOutput(FieldName name, DataType dataType, List<Cluster> clusters) {
        Output output = new Output();
        List outputFields = output.getOutputFields();
        outputFields.add(ModelUtil.createPredictedField(name, DataType.STRING, OpType.CATEGORICAL));
        outputFields.addAll(ModelUtil.createAffinityFields(dataType, clusters));
        return output;
    }
}

