/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

public class SerializationUtil {
    private static final int IS_OBJECT_BIT_MASK = 256;
    private static final int HAS_ATTR_BIT_MASK = 512;
    private static final int HAS_TAG_BIT_MASK = 1024;
    private static final int BYTES_BIT_MASK = 2;
    private static final int LATIN1_BIT_MASK = 4;
    private static final int UTF8_BIT_MASK = 8;

    private SerializationUtil() {
    }

    public static int decodeType(int flags) {
        return flags & 0xFF;
    }

    public static int decodeLevels(int flags) {
        return flags >> 12;
    }

    public static int unpackRefIndex(int flags) {
        return flags >> 8;
    }

    public static boolean isObject(int flags) {
        return SerializationUtil.hasBit(flags, 256);
    }

    public static boolean hasAttributes(int flags) {
        return SerializationUtil.hasBit(flags, 512);
    }

    public static boolean hasTag(int flags) {
        return SerializationUtil.hasBit(flags, 1024);
    }

    public static boolean isBytesCharset(int flags) {
        return SerializationUtil.hasLevelBit(flags, 2);
    }

    public static boolean isLatin1Charset(int flags) {
        return SerializationUtil.hasLevelBit(flags, 4);
    }

    public static boolean isUTF8Charset(int flags) {
        return SerializationUtil.hasLevelBit(flags, 8);
    }

    private static boolean hasLevelBit(int flags, int mask) {
        return SerializationUtil.hasBit(SerializationUtil.decodeLevels(flags), mask);
    }

    private static boolean hasBit(int flags, int mask) {
        return (flags & mask) == mask;
    }
}

