/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jpmml.model.SAXUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class SAXTransformerUtil {
    private SAXTransformerUtil() {
    }

    public static void transform(File input, File output, XMLFilter ... filters) throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException {
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        try (FileOutputStream os = new FileOutputStream(output);){
            TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
            transformerHandler.setResult(new StreamResult(os));
            XMLReader xmlReader = SAXUtil.createFilteredReader((XMLReader)SAXUtil.createXMLReader(), (XMLFilter[])filters);
            xmlReader.setContentHandler(transformerHandler);
            try (FileInputStream is = new FileInputStream(input);){
                xmlReader.parse(new InputSource(is));
            }
        }
    }
}

