% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2spss-deprecated.R
\name{r2spss-deprecated}
\alias{r2spss-deprecated}
\alias{plotSPSS}
\alias{linesSPSS}
\alias{boxplotSPSS}
\alias{histSPSS}
\title{Deprecated functions in r2spss}
\usage{
plotSPSS(data, variables, xlab = NULL, ylab = NULL, ...)

linesSPSS(data, variables, index = NULL, xlab = NULL, ylab = NULL, ...)

boxplotSPSS(
  data,
  variables,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  cut.names = NULL,
  ...
)

histSPSS(data, variable, normal = FALSE, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{data}{a data frame containing the variables to be plotted.}

\item{variables}{For \code{plotSPSS}, a character vector specifying at
least two variables to be plotted.  In case of two variables, a simple
scatter plot is produced with the first variable on the \eqn{x}-axis and the
second variable on the \eqn{y}-axis.  In case of more than two variables, a
scatter plot matrix is produced.

For \code{linesSPSS}, a character vector specifying at least one variable
to be plotted on the \eqn{y}-axis.  In case of multiple variables, separate
lines are drawn for each variable and a legend is shown.

For \code{boxplotSPSS}, a character vector specifying separate variables to
be plotted.  If \code{group} is not \code{NULL}, only the first variable is
used and box plots of groups of observations are drawn instead.}

\item{xlab, ylab}{the axis labels.}

\item{\dots}{additional arguments to be passed down, in particular
graphical parameters (see \code{\link[graphics]{boxplot}},
\code{\link[graphics]{hist}}, and \code{\link[graphics]{par}}).}

\item{index}{a character string specifying a variable to be plotted on the
\eqn{x}-axis, or \code{NULL} to plot the observations against their index.}

\item{group}{an character string specifying a grouping variable, or
\code{NULL} for no grouping.}

\item{cut.names}{a logical indicating whether to cut long variable names or
group labels to 8 characters.  The default is \code{TRUE} for box plots of
separate variables, but \code{FALSE} for box plots of groups of observations
(which mimics SPSS behavior).}

\item{variable}{a character string specifying the variable to be plotted.}

\item{normal}{a logical indicating whether to add a normal density with the
estimated mean and standard deviation (the default is \code{FALSE}).}
}
\value{
\code{plotSPSS} and \code{linesSPSS} do not return anything but produce a
plot.

\code{boxplotSPSS} returns a list containing summary statistics invisibly
(see \code{\link[graphics]{boxplot}}) and produces a plot.

\code{histSPSS} returns an object of class \code{"histogram"} invisibly (see
\code{\link[graphics]{hist}}) and produces a plot.
}
\description{
These functions are deprecated and may be removed as soon as the next
release of \pkg{r2spss}.  The plot functions \code{plotSPSS},
\code{linesSPSS}, \code{boxSPSS}, and \code{histSPSS} are built around
base \R graphics and have been superseded by functions built on
\code{\link[ggplot2:ggplot2-package]{ggplot2}}.
}
\details{
\code{plotSPSS} draws a scatter plot or a scatter plot matrix of variables
in a data frame.

\code{linesSPSS} draws connected lines for variables in a data frame.

\code{boxplotSPSS} draw box plots of variables in a data frame, including
box plots for groups of observations and box plots for separate variables.

\code{histSPSS} draws a histogram of a variable in a data frame.

The plots thereby mimic the look of graphs in older versions of SPSS (<24).
}
\author{
Andreas Alfons
}
\keyword{hplot}
