% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation.R
\name{m_vibrate}
\alias{m_vibrate}
\title{Add model's vibration}
\usage{
m_vibrate(id, numFrames, amplitude, bothWays, arrowSpec)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{numFrames}{Number of frames to be created, default to 10}

\item{amplitude}{Amplitude of distortion, default to 1 (full)}

\item{bothWays}{If true, extend both in positive and negative directions by
numFrames}

\item{arrowSpec}{Specification for drawing animated arrows. If color isn't
specified,
atom color (sphere, stick, line preference) is used.}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
If atoms have dx, dy, dz properties (in some xyz files),
vibrate populates each model's frame property based on parameters.
Models can then be animated.
}
\examples{
library(r3dmol)

xyz <- "4
* (null), Energy   -1000.0000000
N     0.000005    0.019779   -0.000003   -0.157114    0.000052   -0.012746
H     0.931955   -0.364989    0.000003    1.507100   -0.601158   -0.004108
H    -0.465975   -0.364992    0.807088    0.283368    0.257996   -0.583024
H    -0.465979   -0.364991   -0.807088    0.392764    0.342436    0.764260
"

r3dmol() \%>\%
  m_add_model(data = xyz, format = "xyz") \%>\%
  m_set_style(style = m_style_stick()) \%>\%
  m_vibrate(numFrames = 10, amplitude = 1) \%>\%
  m_animate(options = list(loop = "backAndForth", reps = 0)) \%>\%
  m_zoom_to()
}
