/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Planner;

import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.StreetSegment;
import com.conveyal.r5.profile.DominatingList;
import com.conveyal.r5.profile.FareDominatingList;
import com.conveyal.r5.profile.McRaptorSuboptimalPathProfileRouter;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.profile.StreetPath;
import com.conveyal.r5.profile.SuboptimalDominatingList;
import com.conveyal.r5.streets.StreetRouter;
import com.conveyal.r5.transit.TransportNetwork;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntIntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.ipea.r5r.Planner.Trip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(TripPlanner.class);
    private String fromId;
    private String toId;
    private boolean shortestPath;
    private final TransportNetwork transportNetwork;
    private final ProfileRequest request;

    public void setOD(String fromId, String toId) {
        this.fromId = fromId;
        this.toId = toId;
    }

    public void setShortestPath(boolean shortestPath) {
        this.shortestPath = shortestPath;
    }

    public TripPlanner(TransportNetwork transportNetwork, ProfileRequest request) {
        this.transportNetwork = transportNetwork;
        this.request = request;
        this.shortestPath = false;
    }

    public List<Trip> plan() {
        HashMap<String, Trip> trips = new HashMap<String, Trip>();
        this.findDirectPaths(this.request, trips);
        HashMap<LegMode, StreetRouter> accessRouter = null;
        Map<LegMode, StreetRouter> egressRouter = null;
        if (this.request.hasTransit()) {
            accessRouter = this.findAccessPaths(this.request);
            egressRouter = this.findEgressPaths(this.request);
            Map<LegMode, TIntIntMap> accessTimes = accessRouter.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StreetRouter)e.getValue()).getReachedStops()));
            Map<LegMode, TIntIntMap> egressTimes = egressRouter.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StreetRouter)e.getValue()).getReachedStops()));
            IntFunction<DominatingList> listSupplier = this.request.inRoutingFareCalculator != null ? departureTime -> new FareDominatingList(this.request.inRoutingFareCalculator, this.request.maxFare, departureTime + this.request.maxTripDurationMinutes * 60) : t -> new SuboptimalDominatingList(Math.max(this.request.suboptimalMinutes, 0));
            McRaptorSuboptimalPathProfileRouter router = new McRaptorSuboptimalPathProfileRouter(this.transportNetwork, this.request, accessTimes, egressTimes, listSupplier, null, true);
            router.route();
            TIntObjectIterator it = router.finalStatesByDepartureTime.iterator();
            while (it.hasNext()) {
                it.advance();
                int departureTime2 = it.key();
                for (McRaptorSuboptimalPathProfileRouter.McRaptorState state : (Collection)it.value()) {
                    Trip newTrip = new Trip(state, departureTime2, this.transportNetwork, this.request);
                    newTrip.setOD(this.fromId, this.toId, this.request);
                    if (trips.containsKey(newTrip.getKey()) && ((Trip)trips.get(newTrip.getKey())).getTotalDurationSeconds() <= newTrip.getTotalDurationSeconds()) continue;
                    trips.put(newTrip.getKey(), newTrip);
                }
            }
        }
        List<Object> tripList = new ArrayList(trips.values());
        tripList = tripList.stream().filter(trip -> trip.getTotalDurationSeconds() <= this.request.maxTripDurationMinutes * 60 && trip.getTotalFare() <= this.request.maxFare).sorted(Comparator.comparingInt(Trip::directFirst).thenComparingInt(Trip::getNumberOfLegs).thenComparingInt(Trip::getTotalDurationSeconds)).collect(Collectors.toList());
        if (this.shortestPath && !tripList.isEmpty()) {
            tripList = List.of(tripList.stream().min(Comparator.comparingInt(Trip::getTotalDurationSeconds)).get());
        }
        for (Trip trip2 : trips.values()) {
            trip2.augment(accessRouter, egressRouter, this.transportNetwork, this.request);
        }
        return tripList;
    }

    private void findDirectPaths(ProfileRequest request, Map<String, Trip> trips) {
        request.reverseSearch = false;
        for (LegMode mode : request.directModes) {
            StreetRouter.State lastState;
            StreetRouter streetRouter = new StreetRouter(this.transportNetwork.streetLayer);
            streetRouter.profileRequest = request;
            streetRouter.streetMode = StreetMode.valueOf((String)mode.toString());
            int limitSeconds = request.streetTime * 60;
            if (request.hasTransit()) {
                limitSeconds = Math.min(limitSeconds, request.getMaxTimeSeconds(mode));
            }
            streetRouter.timeLimitSeconds = limitSeconds;
            if (streetRouter.setOrigin(request.fromLat, request.fromLon)) {
                if (!streetRouter.setDestination(request.toLat, request.toLon)) {
                    LOG.warn("Direct mode {} destination wasn't found!", (Object)mode);
                    continue;
                }
                streetRouter.route();
                lastState = streetRouter.getState(streetRouter.getDestinationSplit());
                if (lastState == null) {
                    LOG.warn("Direct mode {} last state wasn't found", (Object)mode);
                    continue;
                }
            } else {
                LOG.warn("Direct mode {} origin wasn't found!", (Object)mode);
                continue;
            }
            StreetPath streetPath = new StreetPath(lastState, this.transportNetwork, false);
            StreetSegment streetSegment = new StreetSegment(streetPath, mode, this.transportNetwork.streetLayer);
            LOG.info("adding direct mode {}", (Object)mode);
            Trip trip = Trip.newDirectTrip(request.fromTime, mode.toString(), streetSegment);
            trip.setOD(this.fromId, this.toId, request);
            trips.put(mode.toString(), trip);
        }
    }

    private HashMap<LegMode, StreetRouter> findAccessPaths(ProfileRequest request) {
        request.reverseSearch = false;
        HashMap<LegMode, StreetRouter> accessRouter = new HashMap<LegMode, StreetRouter>();
        for (LegMode mode : request.accessModes) {
            StreetRouter streetRouter = new StreetRouter(this.transportNetwork.streetLayer);
            streetRouter.profileRequest = request;
            streetRouter.streetMode = StreetMode.valueOf((String)mode.toString());
            streetRouter.timeLimitSeconds = request.getMaxTimeSeconds(mode);
            streetRouter.transitStopSearch = true;
            streetRouter.quantityToMinimize = StreetRouter.State.RoutingVariable.DURATION_SECONDS;
            if (streetRouter.setOrigin(request.fromLat, request.fromLon)) {
                streetRouter.route();
                accessRouter.put(mode, streetRouter);
                continue;
            }
            LOG.warn("MODE:{}, Edge near the origin coordinate wasn't found. Routing didn't start!", (Object)mode);
        }
        return accessRouter;
    }

    private Map<LegMode, StreetRouter> findEgressPaths(ProfileRequest request) {
        HashMap<LegMode, StreetRouter> egressRouter = new HashMap<LegMode, StreetRouter>();
        request.reverseSearch = true;
        for (LegMode mode : request.egressModes) {
            StreetRouter streetRouter = new StreetRouter(this.transportNetwork.streetLayer);
            streetRouter.transitStopSearch = true;
            streetRouter.quantityToMinimize = StreetRouter.State.RoutingVariable.DURATION_SECONDS;
            streetRouter.streetMode = StreetMode.valueOf((String)mode.toString());
            streetRouter.profileRequest = request;
            streetRouter.timeLimitSeconds = request.getMaxTimeSeconds(mode);
            if (streetRouter.setOrigin(request.toLat, request.toLon)) {
                streetRouter.route();
                TIntIntMap stops = streetRouter.getReachedStops();
                egressRouter.put(mode, streetRouter);
                LOG.info("Added {} egress stops for mode {}", (Object)stops.size(), (Object)mode);
                continue;
            }
            LOG.warn("MODE:{}, Edge near the origin coordinate wasn't found. Routing didn't start!", (Object)mode);
        }
        return egressRouter;
    }
}

