% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_summary.R
\name{state_summary}
\alias{state_summary}
\title{Download State Summaries}
\usage{
state_summary(organization_id = NULL, reporting_cycle = NULL, tidy = TRUE, ...)
}
\arguments{
\item{organization_id}{(character) Restricts results to the specified
organization. required}

\item{reporting_cycle}{(character) Filters the returned results to the
specified 4 digit reporting cycle year. Typically even numbered years. Will
return reporting data for all years prior to and including the reporting
cycle by reporting cycle. optional}

\item{tidy}{(logical) \code{TRUE} (default) the function returns a tidied
tibble. \code{FALSE} the function returns the raw JSON string.}

\item{...}{list of curl options passed to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
If \code{tidy = FALSE} the raw JSON string is
returned, else the JSON data is parsed and returned as a list of tibbles.
}
\description{
Provides summary information for assessed uses for an organization (State,
Territory or Tribe) and Integrated Reporting Cycle. The Organization ID for
the state, territory or tribe is required. If a Reporting Cycle isn't
provided, the service will return the most recent cycle. If a reporting Cycle
is provided, the service will return a summary for the requested cycle.
}
\note{
See \link{domain_values} to search values that can be queried. Data
downloaded from the EPA webservice is automatically cached to reduce
uneccessary calls to the server. To managed cached files see
\link{rATTAINS_caching}.
}
\examples{

\dontrun{
## Get a list of tibbles summarizing assessed uses
state_summary(organization_id = "TDECWR", reporting_cycle = "2016")

## Returns the query as a JSON string instead
state_summary(organization_id = "TDECWR", reporting_cycle = "2016", tidy = FALSE)
}

}
