% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_amOptions.R
\name{amOptions}
\alias{amOptions}
\title{amOptions}
\usage{
amOptions(chart, theme = "none", legend = FALSE, legendPosition = "right",
  legendAlign = "left", export = FALSE, exportFormat = character(),
  creditsPosition = "top-left", main = character(), mainColor = "#000000",
  mainSize = 15, zoom = FALSE, scrollbar = FALSE, scrollbarHeight = 20,
  labelRotation = 0)
}
\arguments{
\item{chart}{\linkS4class{AmChart}.}

\item{theme}{\code{character}, possible values are : "none", "light", "dark", "patterns",
"chalk", default set to "none".}

\item{legend}{\code{logical}, default \code{FALSE}. TRUE to add a legend to the chart.}

\item{legendPosition}{\code{character}, possible values are : "left", "right", "top" or "bottom", 
default set to "right".}

\item{legendAlign}{\code{character}, controls the legend alignement. Possible values are : 
"left","right" or "center", default set to "left". Only used if \code{legend = TRUE}.}

\item{export}{\code{logical}, default set to  FALSE. TRUE to display export feature.}

\item{exportFormat}{\code{character}, desired export format. Possible values are : "JPG",
"PNG" ,"SVG", "CSV", "JSON", "PDF", "XLSX", "PRINT".}

\item{creditsPosition}{\code{character}, controsl credits position. Possible values are : 
"top-left", "top-right", "bottom-left" or "bottom-right", default set to "top-left".}

\item{main}{\code{character}, chart's title.}

\item{mainColor}{\code{character}, main color (in hexadecimal), default set to "#000000".}

\item{mainSize}{\code{numeric}, main size, default set to 15.}

\item{zoom}{\code{logical}, TRUE to add a chart cursor, default set to FALSE.}

\item{scrollbar}{\code{logical}, default \code{FALSE}, TRUE to display scrollbar.}

\item{scrollbarHeight}{\code{numeric}, height in pixels, must be > 0.}

\item{labelRotation}{\code{numeric}, rotation angle of a label. Only horizontal axis' values 
can be rotated. Value must be between -90 and 90.}
}
\description{
amOptions sets the most common options for chart customization.
You can set other properties with the method \link{setProperties}.
See details for exception.
}
\details{
\strong{Exception:} 
\itemize{
 \item{It's not possible to export a gauge chart data as CSV.}
 }
}
\examples{
\donttest{
library(pipeR)
data(data_pie) 

# Export                 
amPie(data = data_pie) \%>>\%
  amOptions(export = TRUE)

# Legend
amPie(data = data_pie) \%>>\%
  amOptions(legend = TRUE)

# Legend position
amPie(data = data_pie) \%>>\%
  amOptions(legend = TRUE, legendPosition = "bottom")

# Credits position
amPie(data = data_pie) \%>>\%
  amOptions(creditsPosition = "bottom-right")

# Theme
amPie(data = data_pie) \%>>\%
  amOptions(theme = "chalk")

# Title
amPie(data = data_pie) \%>>\%
  amOptions(main = "Social network", mainColor = "#FFFFFF", mainSize = 40, theme = "chalk")


# Custom exemple
amPie(data = data_pie) \%>>\%
  amOptions(main = "Social network", mainColor = "#FFFFFF", mainSize = 40,
            theme = "dark", legend = TRUE, legendPosition = "bottom",
            creditsPosition = "bottom-right" )
}

}
\seealso{
\itemize{
\item{\url{https://datastorm-open.github.io/introduction_ramcharts/}}
}
}

