% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_AmObject.R
\name{addListener}
\alias{addListener}
\alias{addListener,AmObject,character,character-method}
\alias{resetProperties}
\alias{resetProperties,AmObject-method}
\alias{setProperties}
\alias{setProperties,AmObject-method}
\title{AmObject methods}
\usage{
addListener(.Object, name, expression)

\S4method{addListener}{AmObject,character,character}(.Object, name, expression)

resetProperties(.Object, ...)

\S4method{resetProperties}{AmObject}(.Object, ...)

setProperties(.Object, list_prop, ...)

\S4method{setProperties}{AmObject}(.Object, list_prop, ...)
}
\arguments{
\item{.Object}{\code{\linkS4class{AmObject}}.}

\item{name}{\code{character}, name of the listener.}

\item{expression}{\code{character}, associated function event.}

\item{...}{other properties}

\item{list_prop}{(Optional) \code{list} containing properties to set.
The former properties will be overwritten.}
}
\value{
The updated object.
}
\description{
Methods for inherited classes.
}
\details{
Former properties will be overwritten.

Former properties will be overwritten.
}
\examples{
addListener(.Object = amPieChart(),
            name = "clickSlice" ,
            expression = "function(event){ alert('ok !'); }")
            
addListener(.Object = amLegend(),
            name = "select",
            expression = paste0("function onSelect (properties) {",
                                "alert('selected nodes: ' + properties.nodes);",
                                "}"))
library(pipeR)
amPlot(runif(10)) \%>>\% resetProperties("categoryAxis") \%>>\% print(withDetail = FALSE)
library(pipeR)
# either you can set a list
ls <- list(categoryAxis = list(gridPosition = "start"), fontSize = 15)
amSerialChart() \%>>\% setProperties(list = ls)  \%>>\% print()

# or you can set one or more properties
amPieChart() \%>>\% setProperties(handDrawn = TRUE, fontSize = 15) \%>>\% print()

# overwrite a property
amPieChart() \%>>\%  setProperties(fontSize = 15) \%>>\%  setProperties(fontSize = 12) \%>>\% print()

# Carefull if you try to set a property which is a slot...
# in that case, use the setter methods 'setXX' or 'addXX' which check the validity
\dontrun{
amPieChart() %>>% setProperties(type = "serial") %>>% print()
}

amPieChart() \%>>\% setExport()
}
