% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amMekko.R
\name{amMekko}
\alias{amMekko}
\title{Plotting mekko chart (quali vs quali) using rAmCharts}
\usage{
amMekko(x, y, data, xlab = "", ylab = "", groups_color = NULL,
  horiz = FALSE, show_values = FALSE, ...)
}
\arguments{
\item{x}{\code{character}, column name for x-axis.}

\item{y}{\code{character}, column name for y-axis.}

\item{data}{\code{data.frame}, dataframe with values to display.
See \code{\link{data_mekko}}}

\item{xlab}{\code{character}, label for x-axis.}

\item{ylab}{\code{character}, label for y-axis.}

\item{groups_color}{\code{character} vector of colors in hexadecimal, 
same length as the number of y modalities.}

\item{horiz}{\code{logical}, TRUE for an horizontal chart, FALSE for a vertical one.}

\item{show_values}{\code{logical}, TRUE to display values.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amMekko computes a mekko chart of the given values.
}
\examples{
data(data_mekko)
amMekko(x = "var1", y = "var2", data = data_mekko)

\donttest{
# Other examples available which can be time consuming depending on your configuration.
library(pipeR)
 
# Horizontal
amMekko(x = "var1", y = "var2", data = data_mekko, horiz = TRUE)
 
# Display values
amMekko(x = "var1", y = "var2", data = data_mekko, show_values = TRUE)
}

}
\seealso{
\itemize{
\item{\url{https://datastorm-open.github.io/introduction_ramcharts/}}
}
}
