\name{cmaNew}
\alias{cmaNew}
\title{Create a new CMA-ES Java object.}
\usage{
  cmaNew(propFile = NULL)
}
\arguments{
  \item{propFile}{[NULL] filename of a file with property
  settings. If NULL, read file \cr
  \code{CMAEvolutionStrategy.properties} from the package
  directory (\code{find.package("rCMA")})}
}
\value{
  the new CMA-ES Java object of class
  \code{CMAEvolutionStrategy}, which has as additional
  attribute \code{props}, the Java \code{Properties} object
  as read from \code{propFile}.
}
\description{
  Create a new CMA-ES Java object.
}
\note{
  The default properties file can be found in
  \code{CMAEvolutionStrategy.properties}.  A read-only copy
  can be inspected by browsing to "Index" (of package
  rCMA), then "Overview of user guides ...".  \cr It allows
  to set more parameter, especially more
  \link[=cmaSetStopFitness]{stop conditions}.
}
\examples{
## show how element initialX can be inferred from attribute props:
   ## (see  cmaEvalMeanX-documentation for further details on .jcall and its argument "S")
   cma <- cmaNew();
   props <- attr(cma,"props");
   initialX = .jcall(props,"S","getProperty","initialX");
   print(initialX);
}
\author{
  Wolfgang Konen, FHK, 2013
}
\seealso{
  \code{\link{cmaInit}}
}

