% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.plot.group.R
\name{ena.plot.group}
\alias{ena.plot.group}
\title{Plot of ENA set groups}
\usage{
ena.plot.group(enaplot, points = NULL, method = "mean",
  labels = NULL, colors = "black", shape = c("square", "triangle-up",
  "diamond", "circle"), confidence.interval = c("none", "crosshairs",
  "box"), outlier.interval = c("none", "crosshairs", "box"),
  label.offset = "bottom right", label.font.size = NULL,
  label.font.color = NULL, label.font.family = NULL, show.legend = T,
  ...)
}
\arguments{
\item{enaplot}{\code{\link{ENAplot}} object to use for plotting}

\item{points}{A matrix or data.frame where columns contain coordinates of points in a projected ENA space}

\item{method}{A function for computing a summary statistic for each column of points}

\item{labels}{A character which will be the label for the group's point}

\item{colors}{A character, determines color of the group's point, default: enaplot$color}

\item{shape}{A character, determines shape of the group's point, choices:  square, triangle, diamond, circle, default: square}

\item{confidence.interval}{A character that determines how the confidence interval is displayed, choices: none, box, crosshair, default: none}

\item{outlier.interval}{A character that determines how outlier interval is displayed, choices: none, box, crosshair, default: none}

\item{label.offset}{character: top left (default), top center, top right, middle left, middle center, middle right, bottom left, bottom center, bottom right}

\item{label.font.size}{An integer which determines the font size for label, default: enaplot\$font.size}

\item{label.font.color}{A character which determines the color of label, default: enaplot\$font.color}

\item{label.font.family}{A character which determines font type, choices: Arial, Courier New, Times New Roman, default: enaplot\$font.family}

\item{show.legend}{Logical indicating whether to show the point labels in the in legend}

\item{...}{Additional parameters}
}
\value{
The  \code{\link{ENAplot}} provided to the function, with its plot updated to include the new group point.
}
\description{
Plot a point based on a summary statistic computed from a given method (typically, mean) for a set of points in a projected ENA space
}
\details{
Plots a point based on a summary statistic for a group (typically, mean)
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum,
  rotation.by = ena.rotate.by.mean,
  rotation.params = list(
      accum$metadata$Condition=="FirstGame",
      accum$metadata$Condition=="SecondGame"
  )
)

plot = ena.plot(set)

unitNames = set$enadata$units

### Subset rotated points and plot Condition 1 Group Mean
first.game = unitNames$Condition == "FirstGame"
first.game.points = set$points.rotated[first.game,]
plot = ena.plot.group(plot, first.game.points, labels = "FirstGame",
    colors = "red", confidence.interval = "box")

### Subset rotated points and plot Condition 2 Group Mean
second.game = unitNames$Condition == "SecondGame"
second.game.points = set$points.rotated[second.game,]
plot = ena.plot.group(plot, second.game.points, labels = "SecondGame",
    colors  = "blue", confidence.interval = "box")

print(plot);

}
\seealso{
\code{\link{ena.plot}}, \code{ena.plot.points}
}
\keyword{ENA,}
\keyword{group}
\keyword{plot,}
