% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.plot.network.R
\name{ena.plot.network}
\alias{ena.plot.network}
\title{Plot an ENA network}
\usage{
ena.plot.network(
  enaplot = NULL,
  network = NULL,
  node.positions = enaplot$enaset$rotation$nodes,
  adjacency.key = NULL,
  colors = c(pos = enaplot$palette[1], enaplot$palette[2]),
  edge_type = "line",
  show.all.nodes = T,
  threshold = c(0),
  thin.lines.in.front = T,
  layers = c("nodes", "edges"),
  thickness = c(min(abs(network)), max(abs(network))),
  opacity = thickness,
  saturation = thickness,
  scale.range = c(ifelse(min(network) == 0, 0, 0.1), 1),
  node.size = c(3, 10),
  labels = NULL,
  label.offset = "middle right",
  label.font.size = enaplot$get("font.size"),
  label.font.color = enaplot$get("font.color"),
  label.font.family = enaplot$get("font.family"),
  legend.name = NULL,
  legend.include.edges = F,
  scale.weights = F,
  ...
)
}
\arguments{
\item{enaplot}{\code{\link{ENAplot}} object to use for plotting}

\item{network}{dataframe or matrix containing the edge weights for the network graph; typically comes from ENAset$line.weights}

\item{node.positions}{matrix containing the positiions of the nodes. Defaults to enaplot$enaset$node.positions}

\item{adjacency.key}{matrix containing the adjacency key for looking up the names and positions}

\item{colors}{A String or vector of colors for positive and negative line weights. E.g. red or c(pos= red, neg = blue), default: c(pos= red, neg = blue)}

\item{edge_type}{A String representing the type of line to draw, either "line", "dash", or "dot"}

\item{show.all.nodes}{A Logical variable, default: true}

\item{threshold}{A vector of numeric min/max values, default: c(0,Inf) plotting . Edge weights below the min value will not be displayed; edge weights above the max value will be shown at the max value.}

\item{thin.lines.in.front}{A logical, default: true}

\item{layers}{ordering of layers, default: c("nodes", "edges")}

\item{thickness}{A vector of numeric min/max values for thickness, default:  c(min(abs(network)), max(abs(network)))}

\item{opacity}{A vector of numeric min/max values for opacity, default: thickness}

\item{saturation}{A vector of numeric min/max values for saturation, default: thickness}

\item{scale.range}{A vector of numeric min/max to scale from, default: c(0.1,1) or if min(network) is 0, c(0,1)}

\item{node.size}{A lower and upper bound used for scaling the size of the nodes, default c(0, 20)}

\item{labels}{A character vector of node labels, default: code names}

\item{label.offset}{A character vector of representing the positional offset relative to the respective node. Defaults to "middle right" for all nodes. If a single values is provided, it is used for all positions, else the length of the}

\item{label.font.size}{An integer which determines the font size for graph labels, default: enaplot$font.size}

\item{label.font.color}{A character which determines the color of label font, default: enaplot$font.color}

\item{label.font.family}{A character which determines font type, choices: Arial, Courier New, Times New Roman, default: enaplot$font.family}

\item{legend.name}{A character name used in the plot legend. Not included in legend when NULL (Default), if legend.include.edges is TRUE will always be "Nodes"}

\item{legend.include.edges}{Logical value indicating if the edge names should be included in the plot legend. Forces legend.name to be "Nodes"}

\item{scale.weights}{Logical indicating to scale the supplied network}

\item{...}{Additional parameters}
}
\value{
The \code{\link{ENAplot}} provided to the function, with its plot updated to include the nodes and provided connecting lines.
}
\description{
Plot an ENA network: nodes and edges
}
\details{
lots a network graph, including nodes (taken from codes in the ENAplot) and the edges (provided in network)
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum,
  rotation.by = ena.rotate.by.mean,
  rotation.params = list(
    accum$meta.data$Condition=="FirstGame",
    accum$meta.data$Condition=="SecondGame"
  )
)

plot = ena.plot(set)

### Subset rotated points and plot Condition 1 Group Mean
as.matrix(set$points$Condition$FirstGame)

first.game.points = as.matrix(set$points$Condition$FirstGame)
plot = ena.plot.group(plot, first.game.points, labels = "FirstGame",
    colors = "red", confidence.interval = "box")

### Subset rotated points and plot Condition 2 Group Mean
second.game.points = as.matrix(set$points$Condition$SecondGame)
plot = ena.plot.group(plot, second.game.points, labels = "SecondGame",
    colors  = "blue", confidence.interval = "box")

### get mean network plots
first.game.lineweights = as.matrix(set$line.weights$Condition$FirstGame)
first.game.mean = colMeans(first.game.lineweights)

second.game.lineweights = as.matrix(set$line.weights$Condition$SecondGame)
second.game.mean = colMeans(second.game.lineweights)

subtracted.network = first.game.mean - second.game.mean
plot = ena.plot.network(plot, network = subtracted.network)
print(plot)

}
\seealso{
\code{\link{ena.plot}}, \code{\link{ena.plot.points}}
}
