% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espa_order.R
\name{espa_order}
\alias{espa_order}
\title{Places an Order for the Product IDs}
\usage{
espa_order(input_ids, product, file_format = "gtiff",
  resampling_method = "cc", order_note = "Order from R",
  projection = "lonlat", standard_parallel_1 = 29.5,
  central_meridian = -96, datum = "nad83", latitude_of_origin = 23,
  standard_parallel_2 = 45.5, false_northing = 0, false_easting = 0,
  host = "https://espa.cr.usgs.gov/api/v1/", username = NULL,
  password = NULL)
}
\arguments{
\item{input_ids}{vector of product ids for which order needs to be places}

\item{product}{vector of products required for the product ids mentioned. eg. c("sr", "toa", "sr_ndvi")}

\item{file_format}{the required output format of the order. Default "gtiff". Generally available are: "hdf-eos2": "HDF-EOS2", "envi": "ENVI", "gtiff": "GeoTiff", "netcdf": "NetCDF"}

\item{resampling_method}{the required resampling method for the order. Default "cc". Generally available are: "cc": "Cubic Convolution", "bil": "Bilinear Interpolation", "nn": "Nearest Neighbor"}

\item{order_note}{the note (meta information) for the order}

\item{projection}{the projection of the landsat data for which order is placed. Deafult "lonlat". Avaialble are: "aea" and "lonlat"}

\item{standard_parallel_1}{define numeric value if projection is "aea"}

\item{central_meridian}{define numeric value if projection is "aea"}

\item{datum}{define numeric value if projection is "aea"}

\item{latitude_of_origin}{define numeric value if projection is "aea"}

\item{standard_parallel_2}{define numeric value if projection is "aea"}

\item{false_northing}{define numeric value if projection is "aea"}

\item{false_easting}{define numeric value if projection is "aea"}

\item{host}{the api call host. Default set to espa v1 web api}

\item{username}{default NULL, which fetches the username from the global environment. If defined otherwise, will run the api with the provided details}

\item{password}{default NULL, which fetches the password from the global environment. If defined otherwise, will run the api with the provided details}
}
\value{
a list
\item{order_details}{a list of order id and order status if the order was successful, else blank list}
\item{response}{the API response message}
\item{product_available}{dataframe with product ids and availability}
\item{query}{the json body sent in POST api}
}
\description{
Places an order in espa for the specified product ids and their products. All the products must be available for the product IDs mentioned for a successful order
}
\examples{
\dontrun{
# input the credentials, if not defined earlier
espa_creds("your_espaname", "secret_password")

# saving the product ids as a vector
product_ids = c("LC08_L1TP_148047_20180202_20180220_01_T1",
                "LC08_L1TP_134040_20180115_20180120_01_T1")

# saving the required products as a vector
prod = c("sr", "sr_ndvi")

# placing the order
## returns NULL as wrong credentials provided
result = espa_order(input_ids = product_ids, product = prod, projection = "lonlat")
orderid = result$order_details$orderid # storing the order id for future reference}
}
