% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_search.R
\name{query_search}
\alias{query_search}
\title{Search Query Function}
\usage{
query_search(
  search_term,
  query_type = "full_text",
  return_type = "entry",
  scan_params = NULL,
  num_attempts = 1,
  sleep_time = 0.5
)
}
\arguments{
\item{search_term}{A string specifying the term to search in the database.}

\item{query_type}{A string specifying the type of query to perform.
Supported values include "full_text", "PubmedIdQuery",
"TreeEntityQuery", "ExpTypeQuery", "AdvancedAuthorQuery",
"OrganismQuery", "pfam", and "uniprot". Default is "full_text".}

\item{return_type}{A string specifying the type of search result to return.
Possible values are "entry" (default) and "polymer_entity".}

\item{scan_params}{Additional parameters for the scan, provided as a list.
This is `NULL` by default and typically only used for advanced queries.}

\item{num_attempts}{An integer specifying the number of attempts to try the query in case of failure.}

\item{sleep_time}{A numeric value specifying the time in seconds to wait between attempts.}
}
\value{
Depending on the return_type, it either returns a list of PDB IDs (if "entry")
        or the full response from the API.
}
\description{
This function performs a search query against the RCSB Protein Data Bank
using their REST API. It allows for various types of searches based on the provided parameters.
}
\examples{
# Get a list of PDBs for a specific search term
\donttest{
pdbs <- query_search("ribosome")
head(pdbs)

# Search by PubMed ID Number
pdbs_by_pubmedid <- query_search(search_term = 27499440, query_type = "PubmedIdQuery")
head(pdbs_by_pubmedid)

# Search by source organism using NCBI TaxId
pdbs_by_ncbi_taxid <- query_search(search_term = "6239", query_type = "TreeEntityQuery")
head(pdbs_by_ncbi_taxid)
}

}
