% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/it.R
\name{it.cut0}
\alias{it.cut0}
\title{it.cut0}
\usage{
it.cut0(it, tStart = -Inf, tEnd = Inf)
}
\arguments{
\item{it}{IntensityTier object}

\item{tStart}{beginning time of interval to be cut (default \code{-Inf} = cut from the \code{tmin} of the IntensityTier)}

\item{tEnd}{final time of interval to be cut (default \code{Inf} = cut to the \code{tmax} of the IntensityTier)}
}
\value{
IntensityTier object
}
\description{
Cut the specified interval from the IntensityTier and shift time so that the new \code{tmin} = 0
}
\examples{
it <- it.sample()
it2 <-   it.cut(it,  tStart = 0.3)
it2_0 <- it.cut0(it, tStart = 0.3)
it3 <-   it.cut(it,  tStart = 0.2, tEnd = 0.3)
it3_0 <- it.cut0(it, tStart = 0.2, tEnd = 0.3)
it4 <-   it.cut(it,  tEnd = 0.3)
it4_0 <- it.cut0(it, tEnd = 0.3)
it5 <-   it.cut(it,  tStart = -1, tEnd = 1)
it5_0 <- it.cut0(it, tStart = -1, tEnd = 1)
\dontrun{
it.plot(it)
it.plot(it2)
it.plot(it2_0)
it.plot(it3)
it.plot(it3_0)
it.plot(it4)
it.plot(it4_0)
it.plot(it5)
it.plot(it5_0)
}
}
\seealso{
\code{\link{it.cut}}, \code{\link{it.read}}, \code{\link{it.plot}}, \code{\link{it.interpolate}}, \code{\link{it.legendre}}, \code{\link{it.legendreSynth}}, \code{\link{it.legendreDemo}}
}
