% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{intrinsic.matern.operators}
\alias{intrinsic.matern.operators}
\title{Covariance-based approximations of intrinsic fields}
\usage{
intrinsic.matern.operators(
  kappa,
  tau,
  alpha,
  beta = 1,
  G = NULL,
  C = NULL,
  d = NULL,
  mesh = NULL,
  graph = NULL,
  loc_mesh = NULL,
  m_alpha = 2,
  m_beta = 2,
  compute_higher_order = FALSE,
  return_block_list = FALSE,
  type_rational_approximation = c("chebfun", "brasil", "chebfunLB"),
  fem_mesh_matrices = NULL,
  scaling = NULL
)
}
\arguments{
\item{kappa}{range parameter}

\item{tau}{precision parameter}

\item{alpha}{Smoothness parameter}

\item{beta}{Smoothness parameter}

\item{G}{The stiffness matrix of a finite element discretization
of the domain of interest.}

\item{C}{The mass matrix of a finite element discretization of
the domain of interest.}

\item{d}{The dimension of the domain.}

\item{mesh}{An inla mesh.}

\item{graph}{An optional \code{metric_graph} object. Replaces \code{d}, \code{C} and \code{G}.}

\item{loc_mesh}{locations for the mesh for \code{d=1}.}

\item{m_alpha}{The order of the rational approximation for the Matérn part,
which needs to be a positive integer. The default value is 2.}

\item{m_beta}{The order of the rational approximation for the intrinsic part,
which needs to be a positive integer. The default value is 2.}

\item{compute_higher_order}{Logical. Should the higher order finite
element matrices be computed?}

\item{return_block_list}{Logical. For \code{type = "covariance"},
should the block parts of the precision matrix be returned
separately as a list?}

\item{type_rational_approximation}{Which type of rational
approximation should be used? The current types are
"chebfun", "brasil" or "chebfunLB".}

\item{fem_mesh_matrices}{A list containing FEM-related matrices.
The list should contain elements c0, g1, g2, g3, etc.}

\item{scaling}{second lowest eigenvalue of g1}
}
\value{
\code{intrinsic.matern.operators} returns an object of
class "intrinsicCBrSPDEobj". This object is a list containing the
following quantities:
\item{C}{The mass lumped mass matrix.}
\item{Ci}{The inverse of \code{C}.}
\item{GCi}{The stiffness matrix G times \code{Ci}}
\item{Gk}{The stiffness matrix G along with the higher-order
FEM-related matrices G2, G3, etc.}
\item{fem_mesh_matrices}{A list containing the mass lumped mass
matrix, the stiffness matrix and
the higher-order FEM-related matrices.}
\item{m_alpha}{The order of the rational approximation for the Matérn part.}
\item{m_beta}{The order of the rational approximation for the intrinsic part.}
\item{alpha}{The fractional power of the Matérn part of the operator.}
\item{beta}{The fractional power of the intrinsic part of the operator.}
\item{type}{String indicating the type of approximation.}
\item{d}{The dimension of the domain.}
\item{A}{Matrix that sums the components in the approximation to the mesh nodes.}
\item{kappa}{Range parameter of the covariance function}
\item{tau}{Scale parameter of the covariance function.}
\item{type}{String indicating the type of approximation.}
}
\description{
\code{intrinsic.matern.operators} is used for computing a
covariance-based rational SPDE approximation of intrinsic
fields on \eqn{R^d} defined through the SPDE
\deqn{(-\Delta)^{\beta/2}(\kappa^2-\Delta)^{\alpha/2} (\tau u) = \mathcal{W}}{(-\Delta)^{\beta/2}(\kappa^2-\Delta)^{\alpha/2} (\tau u) = \mathcal{W}}
}
\details{
The covariance operator
\deqn{\tau^{-2}(-\Delta)^{\beta}(\kappa^2-\Delta)^{\alpha}}{\tau^{-2}(-\Delta)^{\beta}(\kappa^2-\Delta)^{\alpha}}
is approximated based on rational approximations of the two fractional
components. The Laplacians are equipped with homogeneous Neumann boundary
conditions and a zero-mean constraint is additionally imposed to obtained
a non-intrinsic model.
}
\examples{
if (requireNamespace("RSpectra", quietly = TRUE)){
 x <- seq(from = 0, to = 10, length.out = 201)
 beta <- 1
 alpha <- 1
 kappa <- 1
 op <- intrinsic.matern.operators(kappa = kappa, tau = 1, alpha = alpha, 
                                 beta = beta, loc_mesh = x, d=1) 
 # Compute and plot the variogram of the model
 Sigma <- op$A \%*\% solve(op$Q,t(op$A))
 One <- rep(1, times = ncol(Sigma))
 D <- diag(Sigma)
 Gamma <- 0.5*(One \%*\% t(D) + D \%*\% t(One) - 2 * Sigma)
 k <- 100
 plot(x, Gamma[k, ], type = "l")
 lines(x, 
      variogram.intrinsic.spde(x[k], x, kappa, alpha, beta, L = 10, d = 1),
      col=2, lty = 2)
}
}
