% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph.R
\name{spectral_igraph_membership}
\alias{spectral_igraph_membership}
\title{Spectral clustering for \code{igraph} objects}
\usage{
spectral_igraph_membership(
  g,
  Cn_min = 1L,
  tol = 1e-05,
  names = 1L,
  fix_neig = 0L
)
}
\arguments{
\item{g}{\code{igraph} object}

\item{Cn_min}{minimum cluster size}

\item{tol}{tolerance}

\item{names}{are we dealing with alphaNumeric (1) or numeric (!1) ids}

\item{fix_neig}{whether to fix neighbouring nodes found in same community}
}
\value{
\code{data.frame} with node names and membership information
}
\description{
This function implements the network clustering algorithm described in
(M. E. J. Newman, 2006).
}
\details{
The complete iterative algorithm comprises of two steps. In the
first step, the network is expressed in terms of its leading eigenvalue and eigenvector
and recursively partition into two communities. Partitioning occurs if the maximum
positive eigenvalue is greater than the tolerance (\code{tol=10-5}) for the current
partition, and if it results in a positive contribution to the Modularity.

Given an initial separation using the leading eigen step, the function then continues to
maximise for the change in Modularity using a fine-tuning step - or variate thereof. The
first stage here is to find the node which, when moved from one community to another,
gives the maximum change in Modularity. This node’s community is then fixed and we repeat
the process until all nodes have been moved. The whole process is repeated from this new
state until the change in the Modularity, between the new and old state, is less than the
predefined tolerance (\code{tol}).

A slight variant of the fine-tuning step, which can reduce execution time by factor 2 to
5, is also provided. Instead of moving each node into each community in turn, we only
consider moves of neighbouring nodes, found in different communities, to the community of
the current node of interest. This variant of the node-moving algorithm effectively `fixes`
neigbouring nodes \code{fix_neig} in the community being considered.

The two steps process is repeatedly applied to each new community found, subdivided each community
into two new communities, until we are unable to find any division that results in a positive change
in Modularity. An additional stopping criteria, based on the minimum cluster size \code{Cn_min}, is
also provided.
}
\examples{
data(karate,package='igraphdata')
df.mem<-spectral_igraph_membership(karate)
}
