\docType{methods}
\name{modeMean-methods}
\alias{modeMean}
\alias{modeMean,Tensor-method}
\alias{modeMean-methods}
\title{Tensor Mean Across Single Mode}
\arguments{
  \item{tnsr}{the Tensor instance}

  \item{m}{the index of the mode to average across}

  \item{drop}{whether or not mode m should be dropped}
}
\value{
  K-1 or K Tensor, where \code{K = x@num_modes}
}
\description{
  Given a mode for a K-tensor, this returns the K-1 tensor
  resulting from taking the mean across that particular
  mode.
}
\details{
  \code{modeMean(tnsr,m=NULL,drop=FALSE)}
}
\examples{
tnsr <- rand_tensor()
modeMean(tnsr,1,drop=TRUE)
}
\seealso{
  \code{\link{modeSum}}
}

