% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{store.model.predict}
\alias{store.model.predict}
\title{Store predicted values generated in model functions}
\usage{
\method{store}{model.predict}(object, ..., data = attr(object, "pred_data"),
  name = "prediction")
}
\arguments{
\item{object}{Return value from model function}

\item{...}{Additional arguments}

\item{data}{Data or dataset name (e.g., data = mtcars or data = "mtcars")}

\item{name}{Variable name(s) assigned to predicted values}
}
\description{
Store predicted values generated in model functions
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
regress(diamonds, rvar = "price", evar = c("carat","cut"))  \%>\%
  predict(diamonds) \%>\%
  store(name = "pred, pred_low, pred_high") \%>\% head

}
