% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{write.coeff}
\alias{write.coeff}
\title{Write coefficient table for linear and logistic regression}
\usage{
write.coeff(object, file = "", sort = FALSE, intercept = TRUE)
}
\arguments{
\item{object}{A fitted model object of class regress or logistic}

\item{file}{A character string naming a file. "" indicates output to the console}

\item{sort}{Sort table by variable importance}

\item{intercept}{Include the intercept in the output (TRUE or FALSE). TRUE is the default}
}
\description{
Write coefficient table for linear and logistic regression
}
\details{
Write coefficients and importance scores to csv or or return as a data.frame
}
\examples{

regress(
 diamonds, rvar = "price", evar = c("carat", "clarity", "color", "x"),
 int = c("carat:clarity", "clarity:color", "I(x^2)"), check = "standardize"
) \%>\%
  write.coeff(sort = TRUE) \%>\%
  format_df(dec = 3)

}
