% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb.R
\name{plot.nb}
\alias{plot.nb}
\title{Plot method for the nb function}
\usage{
\method{plot}{nb}(x, plots = "correlations", lev = "All levels", nrobs = 1000, ...)
}
\arguments{
\item{x}{Return value from \code{\link{nb}}}

\item{plots}{Plots to produce for the specified model. Use "" to avoid showing any plots. Use "vimp" for variable importance or "correlations" to examine conditional independence}

\item{lev}{The level(s) in the response variable used as the basis for plots (defaults to "All levels")}

\item{nrobs}{Number of data points to show in scatter plots (-1 for all)}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the nb function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nb.html} for an example in Radiant
}
\examples{
result <- nb(titanic, "survived", c("pclass", "sex"))
plot(result)
result <- nb(titanic, "pclass", c("sex", "age"))
plot(result)

}
\seealso{
\code{\link{nb}} to generate results

\code{\link{summary.nb}} to summarize results

\code{\link{predict.nb}} for prediction
}
