% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{predict_conjoint_by}
\alias{predict_conjoint_by}
\title{Predict method for the conjoint function when a by variables is used}
\usage{
predict_conjoint_by(object, pfun, pred_data = "", pred_cmd = "",
  conf_lev = 0.95, se = FALSE, dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{conjoint}}}

\item{pfun}{Function to use for prediction}

\item{pred_data}{Name of the dataset to use for prediction}

\item{pred_cmd}{Command used to generate data for prediction}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the conjoint function when a by variables is used
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\seealso{
\code{\link{conjoint}} to generate the result

\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}
