% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/conjoint.R
\name{ca_the_table}
\alias{ca_the_table}
\title{Function to calculate the PW and IW table for conjoint}
\usage{
ca_the_table(model, dat, ca_indep_var)
}
\arguments{
\item{model}{Tidied model results (broom) output from \code{\link{conjoint}} passed on by summary.conjoint}

\item{dat}{Conjoint data}

\item{ca_indep_var}{Independent variables used in the conjoint regression}
}
\description{
Function to calculate the PW and IW table for conjoint
}
\details{
See \url{http://mostly-harmless.github.io/radiant/marketing/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint(dataset = "mp3", ca_dep_var = "Rating", ca_indep_var = "Memory:Shape")
ca_the_table(result$model, result$dat, result$ca_indep_var)
}
\seealso{
\code{\link{conjoint}} to generate results

\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}

