% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/full_factor.R
\name{full_factor}
\alias{full_factor}
\title{Factor analysis (PCA)}
\usage{
full_factor(dataset, ff_var, data_filter = "", ff_meth = "PCA",
  ff_number = 2, ff_rotation = "varimax")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{ff_var}{Variables to include in the analysis}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{ff_meth}{Factor extraction method to use}

\item{ff_number}{Number of factors to extract}

\item{ff_rotation}{Apply varimax rotation or no rotation ("varimax" or "none")}
}
\value{
A list with all variables defined in the function as an object of class full_factor
}
\description{
Factor analysis (PCA)
}
\details{
See \url{http://vnijs.github.io/radiant/marketing/full_factor.html} for an example in Radiant
}
\examples{
result <- full_factor("diamonds",c("price","carat","table","x","y"))
result <- full_factor("diamonds",c("price","carat","table","x","y"), ff_meth = "maxlik")
summary(result)
}
\seealso{
\code{\link{summary.full_factor}} to summarize results

\code{\link{plot.full_factor}} to plot results
}

