% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{iterate_grid_from_timestep}
\alias{iterate_grid_from_timestep}
\title{Iterate over a set of timesteps to integrate the pricing differential equation}
\usage{
iterate_grid_from_timestep(starting_time_step, time_pts, z, S0, instruments,
  stock_level_fcn, discount_factor_fcn, default_intensity_fcn,
  variance_cumulation_fcn, dividends = NULL, grid = NULL,
  original_grid_values = as.matrix(grid[1 + starting_time_step, , ]))
}
\arguments{
\item{starting_time_step}{The index into time_pts of the first timestep
to be emplyed.  This must be no larger than the length of time_pts, minus one}

\item{time_pts}{Time nodes to be treated on the grid}

\item{z}{Space grid value morphable to stock prices using \code{stock_level_fcn}}

\item{S0}{Time zero price of the base equity}

\item{instruments}{A list of instruments to be priced.  Each
one must have a \code{strike} and a \code{optionality_fcn}, as
with \code{\link{GridPricedInstrument}} and its subclasses.}

\item{stock_level_fcn}{A function for changing space grid value to stock
prices, with arguments \code{z} and \code{t}}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{default_intensity_fcn}{A function for computing default intensity
occurring during this timestep, dependent on time and stock price, with
arguments \code{t}, \code{S}.}

\item{variance_cumulation_fcn}{A function for computing total stock variance
occurring during this timestep, with arguments \code{T}, \code{t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}}

\item{grid}{An optional grid into which results at each timestep will
be written.  Its size should be at least
\code{(1+starting_time_step, length(z), length(instruments))}}

\item{original_grid_values}{Grid values to timestep from}
}
\value{
Either a populated grid of present values of derivative prices, or a matrix
  of values at the first time point, adapted to \code{z} at
  each timestep.  Time zero value will appear in the first index of any grid.
}
\description{
Timestep an implicit integration scheme to numerically integrate
the pricing differential equation for each of the given instruments,
backwardating from time \code{Tmax} to time 0.
}
\seealso{
Other Implicit Grid Solver: \code{\link{construct_implicit_grid_structure}},
  \code{\link{find_present_value}},
  \code{\link{form_present_value_grid}},
  \code{\link{infer_conforming_time_grid}},
  \code{\link{integrate_pde}},
  \code{\link{take_implicit_timestep}},
  \code{\link{timestep_instruments}}
}

