% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revealPref.R
\name{rAtte}
\alias{rAtte}
\title{Revealed Preference Analysis in Random Limited Attention Models}
\usage{
rAtte(
  menu,
  choice,
  pref_list = NULL,
  method = "GMS",
  nCritSimu = 2000,
  BARatio2MS = 0.1,
  BARatio2UB = 0.1,
  MNRatioGMS = NULL,
  RAM = TRUE,
  AOM = TRUE,
  limDataCorr = TRUE,
  attBinary = 1
)
}
\arguments{
\item{menu}{Numeric matrix of 0s and 1s, the collection of choice problems.}

\item{choice}{Numeric matrix of 0s and 1s, the collection of choices.}

\item{pref_list}{Numeric matrix, each row corresponds to one preference. For example, \code{c(2, 3, 1)} means
2 is preferred to 3 and to 1. When set to \code{NULL}, the default, \code{c(1, 2, 3, ...)},
will be used.}

\item{method}{String, the method for constructing critical values. Default is \code{GMS} (generalized moment selection).
Other available options are \code{LF} (least favorable model), \code{PI} (plug-in method), \code{2MS} (two-step moment selection),
\code{2UB} (two-step moment upper bound), or \code{ALL} (report all critical values).}

\item{nCritSimu}{Integer, number of simulations used to construct the critical value. Default is \code{2000}.}

\item{BARatio2MS}{Numeric, beta-to-alpha ratio for two-step moment selection method. Default is \code{0.1}.}

\item{BARatio2UB}{Numeric, beta-to-alpha ratio for two-step moment upper bound method. Default is \code{0.1}.}

\item{MNRatioGMS}{Numeric, shrinkage parameter. Default is \code{sqrt(1/log(N))}, where N is the sample size.}

\item{RAM}{Boolean, whether the restrictions implied by the random attention model of
Cattaneo, Ma, Masatlioglu, and Suleymanov (2020) should be incorporated, that is, their monotonic attention assumption (default is \code{TRUE}).}

\item{AOM}{Boolean, whether the restrictions implied by the attention overload model of
Cattaneo, Cheung, Ma, and Masatlioglu (2021) should be incorporated, that is, their attention overload assumption (default is \code{TRUE}).}

\item{limDataCorr}{Boolean, whether assuming limited data (default is \code{TRUE}). When set to
\code{FALSE}, will assume all choice problems are observed. This option only applies when \code{RAM} is set to \code{TRUE}.}

\item{attBinary}{Numeric, between 1/2 and 1 (default is \code{1}), whether additional restrictions (on the attention rule)
should be imposed for binary choice problems (i.e., attentive at binaries).}
}
\value{
\item{sumStats}{Summary statistics, generated by \code{\link{sumData}}.}
\item{constraints}{Matrices of constraints, generated by \code{\link{genMat}}.}
\item{Tstat}{Test statistic.}
\item{critVal}{Critical values.}
\item{pVal}{P-values (only available for \code{GMS}, \code{LF} and \code{PI}).}
\item{method}{Method for constructing critical value.}
}
\description{
This has been replaced by \code{\link{revealPref}}.
}
\references{
M. D. Cattaneo, P. Cheung, X. Ma, and Y. Masatlioglu (2021). \href{https://arxiv.org/abs/2110.10650}{Attention Overload}. Working paper.

M. D. Cattaneo, X. Ma, Y. Masatlioglu, and E. Suleymanov (2020). \href{https://arxiv.org/abs/1712.03448}{A Random Attention Model}. \emph{Journal of Political Economy} 128(7): 2796-2836. \doi{10.1086/706861}
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Paul Cheung, University of Maryland. \email{hycheung@umd.edu}

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, Purdue University. \email{esuleyma@purdue.edu}
}
