/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.DataOnMemoryListContainer;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.utils.DataSetGenerator;
import java.util.Random;

public class ReservoirSampling {
    public static DataOnMemory samplingNumberOfSamples(int numberOfSamples, DataStream<? extends DataInstance> dataStream) {
        Random random = new Random(0L);
        DataOnMemoryListContainer<DataInstance> dataOnMemoryList = new DataOnMemoryListContainer<DataInstance>(dataStream.getAttributes());
        int count = 0;
        for (DataInstance dataInstance : dataStream) {
            if (count < numberOfSamples) {
                dataOnMemoryList.add(dataInstance);
            } else {
                int r = random.nextInt(count + 1);
                if (r < numberOfSamples) {
                    dataOnMemoryList.set(r, dataInstance);
                }
            }
            ++count;
        }
        return dataOnMemoryList;
    }

    public static DataOnMemory samplingNumberOfGBs(double numberOfGB, DataStream<? extends DataInstance> dataStream) {
        double numberOfBytesPerSample = (double)dataStream.getAttributes().getFullListOfAttributes().size() * 8.0;
        int numberOfSamples = (int)(0.9 * numberOfGB * 1.073741824E9 / numberOfBytesPerSample);
        return ReservoirSampling.samplingNumberOfSamples(numberOfSamples, dataStream);
    }

    public static void main(String[] args) throws Exception {
        DataStream<DataInstance> data = DataSetGenerator.generate(15, 1000, 5, 5);
        DataOnMemory dataOnMemory = ReservoirSampling.samplingNumberOfSamples(1000, data);
    }
}

