% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangemap_bound.R
\name{rangemap_boundaries}
\alias{rangemap_boundaries}
\title{Species distributional ranges based on administrative boundaries}
\usage{
rangemap_boundaries(occurrences, adm_areas, country_code, boundary_level = 0,
                    polygons, keep_data = FALSE, dissolve = FALSE,
                    final_projection, save_shp = FALSE, name,
                    overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{occurrences}{(optional) a data.frame containing geographic coordinates
of species occurrences, columns must be: Species, Longitude, and Latitude.
Geographic coordinates must be in decimal degrees (WGS84). If not defined,
\code{adm_areas} must be defined and these areas will be used as part of the
species range.}

\item{adm_areas}{(optional, character) a vector of names of administrative
areas known to be occupied by the species, names depend on the
\code{boundary_level} selected. Check the \code{\link{adm_area_names}}
documentation for an idea of how to define names in this parameter. If not
defined, \code{occurrences} must exist.}

\item{country_code}{(optional, character) vector of country codes that will be
considered when creating the species range. Including neighbor countries may
be necessary for obtaining better results. Use \code{\link{rangemap_explore}}
for a preview of all potential countries involved in the analysis. Codes
follow the ISO-3166-1 norm as in function \code{\link[raster]{getData}}.
If not defined, \code{polygons} must be included. Ignored if \code{polygons}
is provided.}

\item{boundary_level}{(numeric) level of the administrative boundaries (from
0 to 2; 0 is the country level and higher values indicate finer divisions).
Default = 0. Ignored if \code{polygons} is defined.}

\item{polygons}{(optional) a SpatialPolygonsDataFrame object that will be used
instead of boundaries specified in \code{country_code} to create species
ranges based on overlapping of species records with these layer, as well as
names defined in \code{adm_areas}. Projection must be WGS84 (EPSG:4326).
If \code{adm_areas} is defined, \code{polygons} must have, as part of its
data, a field (column) named "adm_names" for selecting extra areas based on
names. If \code{polygons} is defined, arguments \code{country_code} and
\code{boundary_level} will be ignored.}

\item{keep_data}{(logical) if \code{TRUE} and \code{polygons} is not defined, data
downloaded from the GADM data base will be kept in the working directory. Useful
if all or part of the downloaded files will be used in posterior analyses since
those files will not be downloaded again and time will be saved. Default =
\code{FALSE}.}

\item{dissolve}{(logical) if \code{TRUE}, distinct polygons selected as part of the
species range will be dissolved for creating simpler shapes, default = \code{FALSE}.
Owing to the high resolution in the GADM data the dissolving process may be
time consuming, specially if the species has a broad
distribution.}

\item{final_projection}{(character) string of projection arguments for resulting
Spatial objects. Arguments must be as in the PROJ.4 documentation. See
\code{\link[sp]{CRS-class}} for details. If \code{NULL}, the default, projection
used is WGS84 (EPSG:4326).}

\item{save_shp}{(logical) if \code{TRUE}, shapefiles of the species range,
occurrences, extent of occurrence, and area of occupancy will be written in
the working directory. Default = \code{FALSE}.}

\item{name}{(character) valid if \code{save_shp} = \code{TRUE}. The name of
the shapefile to be exported. A suffix will be added to \code{name} depending
on the object, as follows: species extent of occurrence = "_extent_occ", area
of occupancy = "_area_occ", and occurrences = "_unique_records".}

\item{overwrite}{(logical) whether or not to overwrite previous results with
the same name. Default = \code{FALSE}.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
A sp_range object (S4) containing: (1) a data.frame with information about
the species range, and SpatialPolygons objects of (2) unique occurrences,
(3) species range, (4) extent of occurrence, and (5) area of occupancy.

If only \code{adm_areas}, the result will be a sp_range object (S4) with two
elements: (1) a data.frame with information about the species range, and
(2) a SpatialPolygons object of the species range.
}
\description{
rangemap_boundaries generates a distributional range for a given
species by considering all the polygons of administrative entities in which
the species has been detected. An approach to the species extent of occurrence
(using convex hulls) and the area of occupancy according to the IUCN criteria
is also generated. Shapefiles can be saved in the working directory if it is
needed.
}
\details{
Data for countries defined in \code{country_code} are downloaded and loaded
using the function \code{\link[raster]{getData}}. Information about country codes
and names of administrative areas, at distinct levels, can be consulted
using: \code{\link{country_codes}} and \code{\link{adm_area_names}}.
}
\examples{
\donttest{
# getting the data
data("occ_d", package = "rangemap")

# checking which countries may be involved in the analysis
rangemap_explore(occurrences = occ_d)

# preparing arguments
level <- 0
adm <- "Ecuador" # Athough no record is on this country, we know it is in Ecuador
countries <- c("PER", "BRA", "COL", "VEN", "ECU", "GUF", "GUY", "SUR", "BOL")

# running using occurrence data
b_range <- rangemap_boundaries(occurrences = occ_d, adm_areas = adm,
                               country_code = countries, boundary_level = level)

summary(b_range)

# running using only names of areas
adm1 <- c("Brazil", "Ecuador", "Peru", "Bolivia", "Colombia", "Venezuela")
b_range1 <- rangemap_boundaries(adm_areas = adm1, country_code = countries,
                                boundary_level = level)

summary(b_range1)
}
}
