#' rangemap: Simple Tools for Defining Species Ranges
#'
#' rangemap contains a collection of tools to create species range maps based on
#' occurrence data, statistics, and spatial objects. Other tools in this
#' collection can be used to analyze the environmental characteristics of
#' the species ranges. Plotting options to represent results in various
#' manners are also available. Results obtained using these tools can be
#' used to explore the distribution of species and define areas of occupancy
#' and extent of occurrence of species.
#'
#' @section rangemap main functions:
#' \code{\link{rangemap_boundaries}}, \code{\link{rangemap_buffer}},
#' \code{\link{rangemap_enm}}, \code{\link{rangemap_explore}},
#' \code{\link{rangemap_plot}}, \code{\link{rangemap_hull}},
#' \code{\link{rangemap_tsa}}, \code{\link{ranges_emaps}},
#' \code{\link{ranges_espace}}
#'
#' @docType package
#' @name rangemap
NULL
