% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangemap_tsa.R
\name{rangemap_tsa}
\alias{rangemap_tsa}
\title{Species distributional ranges based on trend surface analyses}
\usage{
rangemap_tsa(occurrences, region_of_interest, cell_size = 5,
             threshold = 0, simplify = FALSE, simplify_level = 0,
             extent_of_occurrence = TRUE, area_of_occupancy = TRUE,
             final_projection = NULL, save_shp = FALSE,
             save_ts_layer = FALSE, name, overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{occurrences}{a data.frame containing geographic coordinates of species
occurrences, columns must be: Species, Longitude, and Latitude. Geographic
coordinates must be in decimal degrees  (WGS84).}

\item{region_of_interest}{a SpatialPolygonsDataFrame object on which the trend
surface analysis will be performed. For instance, a country, an ecoregion, or
a biogeographic region. Projection must be WGS84 (EPSG:4326).}

\item{cell_size}{(numeric) vector of length 1 or 2, defining the size of cells
(km) at which the resultant trend surface will be created; default = 5.
\code{cell_size} will depend on the extent of \code{region_of_interest}.
Values lower than 1 are only recommended when the species is locally distributed.}

\item{threshold}{(numeric) percentage of occurrence records to be excluded
when deciding the minimum value trend surface output to be considered as part
of the species range. Default = 0.}

\item{simplify}{(logical) if \code{TRUE}, polygons of suitable areas will be
simplified at a tolerance defined in \code{simplify_level}. Default =
\code{FALSE}.}

\item{simplify_level}{(numeric) tolerance at the moment of simplifying polygons
created using the trend surface model. Lower values will produce polygons more
similar to the original geometry. Default = 0. If simplifying is needed, try
numbers between 0 and 1 first.}

\item{extent_of_occurrence}{(logical) whether to obtain the extent of occurrence
of the species based on a simple convex hull polygon; default = \code{TRUE}.}

\item{area_of_occupancy}{(logical) whether to obtain the area of occupancy
of the species based on a simple grid of 4 km^2 resolution;
default = \code{TRUE}.}

\item{final_projection}{(character) string of projection arguments for resulting
Spatial objects. Arguments must be as in the PROJ.4 documentation. See
\code{\link[sp]{CRS-class}} for details. If \code{NULL}, the default, projection
used is WGS84 (EPSG:4326).}

\item{save_shp}{(logical) if \code{TRUE}, shapefiles of the species range,
occurrences, extent of occurrence, and area of occupancy will be written in
the working directory. Default = \code{FALSE}.}

\item{save_ts_layer}{(logical) if \code{TRUE}, the TSA layer will be included
as part of the object returned. If \code{save_shp} = TRUE, the TSA layer will
be written in GeoTiff format. Default = \code{FALSE}}

\item{name}{(character) valid if \code{save_shp} = TRUE. The name of the
geographic files to be exported. A suffix will be added to \code{name}
depending on the object as follows: species extent of occurrence = "_extent_occ",
area of occupancy = "_area_occ", occurrences = "_unique_records", and,
if \code{save_ts_layer} = \code{TRUE}, trend surface layer "_tsa".}

\item{overwrite}{(logical) whether or not to overwrite previous results with
the same name. Default = \code{FALSE}.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
A sp_range object (S4) containing: (1) a data.frame with information about
the species range, and SpatialPolygons objects of (2) unique occurrences,
(3) species range, (4) extent of occurrence, and (5) area of occupancy.
If \code{save_ts_layer} = TRUE, a (6) TSA layer will be included as well.

If \code{extent_of_occurrence} and/or \code{area_of_occupancy} = \code{FALSE},
the corresponding spatial objects in the resulting sp_range object will be
empty, an areas will have a value of 0.
}
\description{
rangemap_tsa generates a distributional range for a given species
using a trend surface analysis. An approach to the species extent of occurrence
(using convex hulls) and the area of occupancy according to the IUCN criteria
is also generated. Shapefiles can be saved in the working directory if it is
needed.
}
\details{
All resulting Spatial objects in the results will be projected to the
\code{final_projection}. Areas are calculated in square kilometers using the
Lambert Azimuthal Equal Area projection, centered on the centroid of occurrence
points given as inputs.

Trend surface analysis is a method based on low-order polynomials of spatial
coordinates for estimating a regular grid of points from scattered observations.
This method assumes that all cells not occupied by occurrences are absences;
hence its use depends on the quality of data and the certainty of having or
not a complete sampling of the \code{regiong_of_interest}.
}
\examples{
# data
data("occ_f", package = "rangemap")

CU <- simple_wmap("simple", regions = "Cuba")

# running
tsa_range <- rangemap_tsa(occurrences = occ_f, region_of_interest = CU,
                          cell_size = 5)

summary(tsa_range)
}
