% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stagingData.R
\name{stagingData}
\alias{stagingData}
\alias{listStagingData}
\alias{mtimeStagingData}
\alias{saveStagingData}
\alias{loadStagingData}
\alias{deleteStagingData}
\alias{cleanStagingData}
\alias{pathStagingData}
\title{Staging data functions}
\usage{
listStagingData(registryName, dir = Sys.getenv("R_RAP_CONFIG_PATH"))

mtimeStagingData(registryName, dir = Sys.getenv("R_RAP_CONFIG_PATH"))

saveStagingData(
  registryName,
  dataName,
  data,
  dir = Sys.getenv("R_RAP_CONFIG_PATH")
)

loadStagingData(registryName, dataName, dir = Sys.getenv("R_RAP_CONFIG_PATH"))

deleteStagingData(
  registryName,
  dataName,
  dir = Sys.getenv("R_RAP_CONFIG_PATH")
)

cleanStagingData(eolAge, dryRun = TRUE)

pathStagingData(registryName, dir)
}
\arguments{
\item{registryName}{Character string providing the registry name.}

\item{dir}{Character string providing the path to where the staging data
directory resides. Default value is \code{Sys.getenv("R_RAP_CONFIG_PATH")}.}

\item{dataName}{Character string providing the data set name.}

\item{data}{A data object such as a data.frame to be stored as
\code{dataName}.}

\item{eolAge}{Numeric providing the staging file end-of-life age in seconds.
Based on the current time and the file modification time stamp staging files
older than \code{eolAge} will be identified as subject for removal.}

\item{dryRun}{Logical defining if function is to be run in dry (none
destructive) mode.}
}
\value{
\itemize{
  \item \code{listStagingData()} returns a character vector of staging data
    files for the given registry (\code{registryName}).
  \item \code{mtimeStagingData()} returns a staging file-named POSIXct vector
    of modification times for the given registry (\code{registryName}).
  \item \code{saveStagingData()} returns the data object (\code{data}),
    invisibly.
  \item \code{loadStagingData()} returns the data object corresponding to
    the name given upon saving (\code{dataName}). If the requested data set
    for loading does not exist the function returns FALSE.
  \item \code{deleteStagingData()} returns TRUE if the file was deleted and
    FALSE if not.
  \item \code{cleanStagingData()} returns a list of files (to be) removed.
  \item \code{rapbase:::pathStagingData()} is an internal helper function and
    returns a character string with the path to the staging directory of
    \code{registryName}. If its parent directory (\code{dir}) does not exists
    an error is returned.
}
}
\description{
Low level functions for handling registry staging data at Rapporteket. As
such, these functions does not provide staging data management \emph{per se}.
Proper management, \emph{e.g.} staging data updates and fallback logic
must therefore be established within each registry that take staging data
into use.
}
\details{
\code{cleanStagingData()} globally removes all staging data files older than
the end-of-life age provided. This is potentially a vastly destructive
function that should be used with great care.
}
\examples{
## Prep test data
registryName <- "myReg"
dataName <- "testData"
data <- mtcars
dir <- tempdir()

## Save data for staging
saveStagingData(registryName, dataName, data, dir)

## List files currently in staging
listStagingData(registryName, dir)

## Retrieve data set from staging
loadStagingData(registryName, dataName, dir)

## Get modification time for staging file(s)
mtimeStagingData(registryName, dir)
}
