% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReport.R
\name{filterAutoRep}
\alias{filterAutoRep}
\title{Filter auto report data}
\usage{
filterAutoRep(data, by, pass)
}
\arguments{
\item{data}{List (nested) specifying auto reports to be filtered. May be
obtained by \code{rapbase::getConfig(fileName = "autoReport.yml")}}

\item{by}{Character string defining the filtering entity and must be one of
\code{c("package", "type", "owner", "organization")}. The term 'package'
represents the registry name}

\item{pass}{Character vector defining the values of the filtering entity that
will allow reports to pass through the filter}
}
\value{
List of auto reports matching the filtering criteria
}
\description{
Generic function to filter various entities from auto report data
}
\examples{
ar <- list(ar1 = list(type = "A"), ar2 = list(type = "B"))
filterAutoRep(ar, "type", "B") # ar2

}
