% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simulated_data}
\alias{sim_rs}
\alias{sim_ru}
\alias{simulated_data}
\title{Simulated dataset for a conservation planning exercise}
\format{\code{SpatialPolyognsDataFrame}, \code{RasterStack}, \code{list} of \code{DemandPoint} objects.}
\usage{
sim_ru

sim_rs
}
\description{
This dataset contains all the data needed to generate prioritisations for three simulated species. This dataset contains planning units, species distribution
maps, and demand points for each species. For the purposes of exploring the behaviour of the problem, demand points were generated using the centroids of planning units
and the probability that they are occupied by the species. Note that methodology is not encouraged for real-world conservation planning.
The species were simulated to represent different simplified versions of species distributions encountered:
\itemize{
\item uniform: This species has an equal probability (0.5) of occurring in all planning units.
\item normal: This species has a single range-core where it is most likely to be found. It is less likely to be found in areas further away from the centre of its range.
\item bimodal: This species has two distinct ecotypes. Each ecotype has its own range cores and range marginal areas.
}
}
\details{
The objects contained in this dataset are:
\itemize{
\item sim_ru: A \code{RapUnsolved} object with all the simulated data.
\item sim_rs: A \code{RapSolved} object with 5 near-optimal solutions.
}
}
\examples{
# load data
data(sim_ru, sim_rs)
# plot species distributions
spp.plot(sim_ru, 1)
spp.plot(sim_ru, 2)
spp.plot(sim_ru, 3)
# plot selection frequencies
plot(sim_rs)
# plot best solution
plot(sim_rs, 0)
}
\keyword{datasets}

