% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GurobiOpts.R
\name{GurobiOpts}
\alias{GurobiOpts}
\title{Create GurobiOpts object}
\usage{
GurobiOpts(
  Threads = 1L,
  MIPGap = 0.1,
  Method = 0L,
  Presolve = 2L,
  TimeLimit = NA_integer_,
  NumberSolutions = 1L,
  MultipleSolutionsMethod = c("benders.cuts", "solution.pool.0", "solution.pool.1",
    "solution.pool.2")[1]
)
}
\arguments{
\item{Threads}{\code{integer} number of cores to use for processing.
Defaults to 1L.}

\item{MIPGap}{\code{numeric} MIP gap specifying minimum solution quality.
Defaults to 0.1.}

\item{Method}{\code{integer} Algorithm to use for solving model. Defaults to
0L.}

\item{Presolve}{\code{integer} code for level of computation in presolve
(lp_solve parameter). Defaults to 2.}

\item{TimeLimit}{\code{integer} number of seconds to allow for solving.
Defaults to \code{NA_integer_}, and so a time limit is not imposed.}

\item{NumberSolutions}{\code{integer} number of solutions to generate.
Defaults to 1L.}

\item{MultipleSolutionsMethod}{\code{integer} name of method to obtain
multiple solutions (used when \code{NumberSolutions} is greater than one).
Available options are \code{"benders.cuts"}, \code{"solution.pool.0"},
\code{"solution.pool.1"}, and \code{"solution.pool.2"}. The
\code{"benders.cuts"} method produces a set of distinct solutions that
are all within the optimality gap. The \code{"solution.pool.0"}
method returns all solutions identified whilst trying to find
a solution that is within the specified optimality gap. The
\code{"solution.pool.1"} method finds one solution within the optimality
gap and a number of additional solutions that are of any level of quality
(such that the total number of solutions is equal to
\code{number_solutions}). The \code{"solution.pool.2"} finds a
specified number of solutions that are nearest to optimality. The
search pool methods correspond to the parameters used by the Gurobi
software suite (see \url{http://www.gurobi.com/documentation/8.0/refman/poolsearchmode.html#parameter:PoolSearchMode}).
Defaults to \code{"benders.cuts"}.}
}
\value{
\code{GurobiOpts} object
}
\description{
This function creates a new GurobiOpts object.
}
\examples{
# create GurobiOpts object using default parameters
GurobiOpts(Threads = 1L, MIPGap = 0.1, Method = 0L, Presolve=2L,
           TimeLimit = NA_integer_, NumberSolutions = 1L)

}
\seealso{
\linkS4class{GurobiOpts}.
}
