% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_qablanks.R
\name{aqs_qablanks}
\alias{aqs_qablanks}
\alias{qablanks_bysite}
\alias{qablanks_bycounty}
\alias{qablanks_bystate}
\alias{qablanks_bypqao}
\alias{qablanks_byma}
\title{AQS API QA Blanks Data service}
\usage{
aqs_qablanks(
  aqs_filter = c("bySite", "byCounty", "byState", "byPQAO", "byMA"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

qablanks_bysite(
  param,
  bdate,
  edate,
  state,
  county,
  site,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

qablanks_bycounty(
  param,
  bdate,
  edate,
  state,
  county,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

qablanks_bystate(
  param,
  bdate,
  edate,
  state,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

qablanks_bypqao(
  param,
  bdate,
  edate,
  pqao,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

qablanks_byma(
  param,
  bdate,
  edate,
  agency,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{param}{A string or vector of strings specifying the 5-digit AQS
parameter code for data selection. An integer will be coerced to a string.
A maximum of 5 parameter codes may be listed in a single request. A list
of the parameter codes can be obtained via \link{list_parametersbyclass}.}

\item{bdate}{A string specifying the begin date of data selection in
YYYYMMDD format. Only the year portion is used.}

\item{edate}{A string specifying the end date of data selection in YYYYMMDD
format. Only the year portion is used. If the end date is not in the same
year as the begin date, the function will automatically split the date
range into multiple chunks by year and send requests sequentially.}

\item{state}{A string specifying the 2-digit state FIPS code. An integer
will be coerced to a string with a leading zero if necessary (e.g., 1 ->
"01"). A list of the state codes can be obtained via \link{list_states}.}

\item{county}{A string specifying the 3-digit county FIPS code. An integer
will be coerced to a string with leading zeros if necessary (e.g., 89 ->
"089"). A list of the county codes within each state can be obtained via
\link{list_countiesbystate}.}

\item{site}{A string specifying the 4-digit AQS site number within the
county. An integer will be coerced to a string with leading zeros if
necessary (e.g., 14 -> "0014"). A list of the site codes within each
county can be obtained via \link{list_sitesbycounty}.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{pqao}{A string specifying the AQS Primary Quality Assurance
Organization (PQAO) code. A list of the PQAO codes can be obtained via
\link{list_pqaos}.}

\item{agency}{A string specifying the AQS Monitoring Agency (MA) code. A
list of the MA codes can be obtained via \link{list_mas}. Here, we named this
input as \code{agency} instead of "ma" because \code{agency} is actually used in the
API endpoint URL.}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch the concentration of from blank samples.
}
\details{
\link{aqs_qablanks} sends a request to the AQS API based on a user-provided
filter using the following underlying functions:
\itemize{
\item \link{qablanks_bysite} returns \code{param} blank data for \code{site} in \code{county},
within \code{state}, between \code{bdate} and \code{edate}.
\item \link{qablanks_bycounty} returns \code{param} blank data for \code{county} in \code{state}
between \code{bdate} and \code{edate}.
\item \link{qablanks_bystate} returns \code{param} blank data for \code{state} between \code{bdate}
and \code{edate}.
\item \link{qablanks_bypqao} returns \code{param} blank data for \code{pqao} between \code{bdate}
and \code{edate}.
\item \link{qablanks_byma} returns \code{param} blank data for \code{agency} (monitoring
agency) between \code{bdate} and \code{edate}.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

## Example from the AQS website
## PM2.5 blank data for Alabama for January 2018
aqs_variables <- list(
  param = "88101", bdate = "20180101", edate = "20180131",
  state = "01"
)
aqs_qablanks(aqs_filter = "byState", aqs_variables = aqs_variables)

## Equivalent to above; used integers instead of strings
qablanks_bystate(
  param = 88101, bdate = "20180101", edate = "20180131",
  state = 1
)
}

}
