% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_quarterlydata.R
\name{aqs_quarterlydata}
\alias{aqs_quarterlydata}
\alias{quarterlydata_bysite}
\alias{quarterlydata_bycounty}
\alias{quarterlydata_bystate}
\alias{quarterlydata_bybox}
\alias{quarterlydata_bycbsa}
\title{AQS API Quarterly Summary Data service}
\usage{
aqs_quarterlydata(
  aqs_filter = c("bySite", "byCounty", "byState", "byBox", "byCBSA"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

quarterlydata_bysite(
  param,
  bdate,
  edate,
  state,
  county,
  site,
  email = get_aqs_email(),
  key = get_aqs_key(),
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

quarterlydata_bycounty(
  param,
  bdate,
  edate,
  state,
  county,
  email = get_aqs_email(),
  key = get_aqs_key(),
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

quarterlydata_bystate(
  param,
  bdate,
  edate,
  state,
  email = get_aqs_email(),
  key = get_aqs_key(),
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

quarterlydata_bybox(
  param,
  bdate,
  edate,
  minlat,
  maxlat,
  minlon,
  maxlon,
  email = get_aqs_email(),
  key = get_aqs_key(),
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)

quarterlydata_bycbsa(
  param,
  bdate,
  edate,
  cbsa,
  email = get_aqs_email(),
  key = get_aqs_key(),
  cbdate = NULL,
  cedate = NULL,
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{param}{A string or vector of strings specifying the 5-digit AQS
parameter code for data selection. An integer will be coerced to a string.
A maximum of 5 parameter codes may be listed in a single request. A list
of the parameter codes can be obtained via \link{list_parametersbyclass}.}

\item{bdate}{A string specifying the begin date of data selection in
YYYYMMDD format. Only the year portion is used.}

\item{edate}{A string specifying the end date of data selection in YYYYMMDD
format. Only the year portion is used. If the end date is not in the same
year as the begin date, the function will automatically split the date
range into multiple chunks by year and send requests sequentially.}

\item{state}{A string specifying the 2-digit state FIPS code. An integer
will be coerced to a string with a leading zero if necessary (e.g., 1 ->
"01"). A list of the state codes can be obtained via \link{list_states}.}

\item{county}{A string specifying the 3-digit county FIPS code. An integer
will be coerced to a string with leading zeros if necessary (e.g., 89 ->
"089"). A list of the county codes within each state can be obtained via
\link{list_countiesbystate}.}

\item{site}{A string specifying the 4-digit AQS site number within the
county. An integer will be coerced to a string with leading zeros if
necessary (e.g., 14 -> "0014"). A list of the site codes within each
county can be obtained via \link{list_sitesbycounty}.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{cbdate}{(optional) A string specifying the change begin date in
YYYYMMDD format to subset data based on "date of last change" in database.
Only data that changed on or after this date will be returned.}

\item{cedate}{(optional) A string specifying the change end date in YYYYMMDD
format to subset data based on "date of last change" in database. Only
data that changed on or before this date will be returned.}

\item{minlat}{A string or numeric value specifying the minimum latitude of a
geographic box. Decimal latitude with north being positive.}

\item{maxlat}{A string or numeric value specifying the maximum latitude of a
geographic box. Decimal latitude with north being positive.}

\item{minlon}{A string or numeric value specifying the minimum longitude of
a geographic box. Decimal longitude with east being positive.}

\item{maxlon}{A string or numeric value specifying the maximum longitude of
a geographic box. Decimal longitude with east being positive.}

\item{cbsa}{A string specifying the AQS CBSA code. A list of the CBSA codes
can be obtained via \link{list_cbsas}.}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch data summarized at the calendar quarter
level. Data is labeled with quarter number (Q1 = Jan - Mar, Q2 = Apr - Jun,
Q3 = Jul - Sep, Q4 = Oct - Dec). All quarters for the specified year are
returned. Note that only the year portion of the bdate and edate are used
and all 4 quarters in the year are returned. In addition, \code{duration} is not
allowed on the API unlike \link{aqs_sampledata}, \link{aqs_dailydata}, and
\link{aqs_annualdata}.
}
\details{
\link{aqs_quarterlydata} sends a request to the AQS API based on a user-provided
filter using the following underlying functions:
\itemize{
\item \link{quarterlydata_bysite} returns quarterly summary \code{param} data for \code{site}
in \code{county}, within \code{state}, based on the year portions of \code{bdate} and
\code{edate}.
\item \link{quarterlydata_bycounty} returns quarterly summary \code{param} data for
\code{county} in \code{state} based on the year portions \code{bdate} and \code{edate}.
\item \link{quarterlydata_bystate} returns quarterly summary \code{param} data for \code{state}
based on the year portions of \code{bdate} and \code{edate}.
\item \link{quarterlydata_bybox} returns quarterly summary \code{param} data for a
user-provided latitude/longitude bounding box (\code{minlat}, \code{maxlat}, \code{minlon},
\code{maxlon}) based on the year portions of \code{bdate} and \code{edate}.
\item \link{quarterlydata_bycbsa} returns quarterly summary \code{param} data for a
user-provided CBSA based on the year portions of \code{bdate} and \code{edate}.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

## Example from the AQS website
## FRM/FEM PM2.5 data for Wake County, NC for 2016
## Only the year portions of bdate and edate are used
aqs_variables <- list(
  param = c("88101", "88502"), bdate = "20160101", edate = "20160228",
  state = "37", county = "183"
)
aqs_quarterlydata(aqs_filter = "byCounty", aqs_variables = aqs_variables)

## Equivalent to above; used integers instead of strings
quarterlydata_bycounty(
  param = c(88101, 88502), bdate = "20160101", edate = "20160228",
  state = 37, county = 183
)
}

}
