% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rasterly_heatmap.R
\name{add_rasterly_heatmap}
\alias{add_rasterly_heatmap}
\title{Add "rasterly" trace to a Plotly visualization}
\usage{
add_rasterly_heatmap(p, x = NULL, y = NULL, z = NULL, ...,
  data = NULL, inherit = TRUE, on = NULL, size = NULL,
  scaling = NULL)
}
\arguments{
\item{p}{A \code{plotly} object}

\item{x}{Numeric vector or expression. The x variable, to be passed on to `aes()`.}

\item{y}{Numeric or expression. The y variable, to be passed on to `aes()`.}

\item{z}{Numeric. A numeric matrix (optional), to be processed with `add_heatmap`.}

\item{...}{Arguments (i.e., attributes) passed along to the trace type or `rasterly`.}

\item{data}{A data.frame or \link[crosstalk]{SharedData} object (optional).}

\item{inherit}{Logical. Inherit attributes from \link[plotly]{plotly}?}

\item{on}{Numeric vector or expression. Provides the data on which to reduce, to be passed on to `aes()`.}

\item{size}{Numeric vector or expression. Pixel size for each observation, to be passed on to `aes()`.}

\item{scaling}{Character string or function. The scaling method to be used for the trace.}
}
\description{
Add trace to a Plotly visualization.
}
\examples{
\dontrun{
library(rasterly)
if(requireNamespace("plotly") && requireNamespace("data.table")) {
 # Load data
 url1 <- "https://raw.githubusercontent.com/plotly/datasets/master/uber-rides-data1.csv"
 ridesRaw_1 <-  url1 \%>\%
   data.table::fread(stringsAsFactors = FALSE)
 url2 <- "https://raw.githubusercontent.com/plotly/datasets/master/uber-rides-data2.csv"
 ridesRaw_2 <-  url2 \%>\%
   data.table::fread(stringsAsFactors = FALSE)
 url3 <- "https://raw.githubusercontent.com/plotly/datasets/master/uber-rides-data3.csv"
 ridesRaw_3 <-  url3 \%>\%
   data.table::fread(stringsAsFactors = FALSE) 
   
 ridesDf <- list(ridesRaw_1, ridesRaw_2, ridesRaw_3) \%>\%
   data.table::rbindlist()

 #### quick start
 p <- plot_ly(data = ridesDf) \%>\%
        add_rasterly_heatmap(x = ~Lat, y = ~Lon)
 p
 #### set artificial scaling function
 zeroOneTransform <- function(z) {
   minz <- min(z)
   maxz <- max(z)
   M <- matrix((z - minz)/(maxz - minz), nrow = dim(z)[1])
   return(M)
 }
 plot_ly(data = ridesDf) \%>\%
   add_rasterly_heatmap(x = ~Lat,
                y = ~Lon,
                on = ~-Lat,
                reduction_func = "max",
                scaling = zeroOneTransform) \%>\%
   plotly::layout(
     xaxis = list(
       title = "x"
     ),
     yaxis = list(
       title = "y"
     )
   )
 }
}
}
