% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset.R
\name{reset}
\alias{reset}
\title{Re-create a rate-limited function}
\usage{
reset(f)
}
\arguments{
\item{f}{A rate-limited function or group of functions}
}
\description{
This function does not modify the original rate-limited function, instead
it returns a new function with the same rate limits (but no memory of prior
function calls).
}
\examples{
f <- function() NULL
f_lim <- limit_rate(f, rate(n = 1, period = .1))
f_lim() ## the next call to f_lim will trigger the rate limit

f_lim2 <- reset(f_lim) ## but f_lim2 has a fresh start

## f_lim2 behaves as though no calls have been made
system.time(f_lim2())

## while f_lim is still constrained
system.time(f_lim())

}

