% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict.rater_fit}
\alias{posterior_predict.rater_fit}
\alias{posterior_predict}
\title{Draw from the posterior predictive distribution}
\usage{
\method{posterior_predict}{rater_fit}(object, new_data, seed = NULL, ...)
}
\arguments{
\item{object}{A \code{rater_fit} object.}

\item{new_data}{New data for the model to be fit to. The must be in the form
used in \code{rater()} except without the 'rating' column.}

\item{seed}{An optional random seed to use.}

\item{...}{Other arguments.}
}
\value{
The passed \code{new_data} augmented with a column 'z' containing the
latent class of each item and 'rating' containing the simulated rating.
}
\description{
Draw from the posterior predictive distribution
}
\details{
The number of raters implied by the entries in the rater column
must match the number of raters in the fitted model.
}
\examples{

\donttest{

fit <- rater(anesthesia, "dawid_skene", verbose = FALSE)
new_data <- data.frame(item = rep(1:2, each = 5), rater = rep(1:5, 2))

predictions <- posterior_predict(fit, new_data)
predictions

}

}
