% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-components.R
\name{group_box}
\alias{group_box}
\alias{flex_group_box}
\title{Group input elements into a box with title}
\usage{
group_box(title, ..., class = NULL)

flex_group_box(title, ..., class = NULL, wrap = "wrap", direction = "row")
}
\arguments{
\item{title}{the box title}

\item{...}{elements to be included or to be passed to other methods}

\item{class}{additional class of the box}

\item{wrap, direction}{see \code{\link[shidashi]{flex_container}}}
}
\value{
A 'HTML' tag
}
\description{
Only works in template framework provided by \code{'shidashi'}
package, see \code{\link[shidashi]{use_template}}
}
\examples{


library(shiny)
library(shidashi)
library(ravedash)

group_box(
  title = "Analysis Group A",
  selectInput("a", "Condition", choices = c("A", "B")),
  sliderInput("b", "Time range", min = 0, max = 1, value = c(0,1))
)

flex_group_box(
  title = "Project and Subject",
  flex_item( "Some input 1" ),
  flex_item( "Some input 2" ),
  flex_break(),
  flex_item( "Some input in new line" )
)

}
