% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-app.R
\name{temp_file}
\alias{temp_file}
\alias{temp_dir}
\title{Create a random temporary file path for current session}
\usage{
temp_file(
  pattern = "file",
  fileext = "",
  persist = c("process", "app-session", "package-cache")
)

temp_dir(check = FALSE, persist = c("process", "app-session", "package-cache"))
}
\arguments{
\item{pattern, fileext}{see \code{\link{tempfile}}}

\item{persist}{persist level, choices are \code{'app-session'},
\code{'package-cache'}, and \code{'process'}; see 'Details'.
'RAVE' application session, default), \code{'package-cache'} (package-level
cache directory)}

\item{check}{whether to create the temporary directory}
}
\value{
A file or a directory path to persist temporary data cache
}
\description{
Create a random temporary file path for current session
}
\details{
R default \code{\link{tempdir}} usually gets removed once the R
process ends. This behavior might not meet all the needs for 'RAVE' modules.
For example, some data are 'RAVE' session-based, like current or last visited
subject, project, or state data (like bookmarks, configurations). This
session-based information will be useful when launching the same 'RAVE'
instance next time, hence should not be removed when users close R.
Other data, such as subject-related, or package-related should last even
longer. These types of data may be cache of subject power,
package-generated color schemes, often irrelevant from R or 'RAVE' sessions,
and can be shared across different 'RAVE' instances.

The default scheme is \code{persist='process'}. Under this mode, this
function behaves the same as \code{\link{tempfile}}. To store data in 'RAVE'
session-based manner, please use \code{persist='app-session'}.
The actual path will be inside of 'RAVE' session folder, hence this option
is valid only if 'RAVE' instance is running. When
'RAVE' instance is not running, the result falls back to
\code{persist='process'}. When \code{persist='process'},
To cache larger and session-irrelevant data, use \code{'package-cache'}.

The 'RAVE' session and package cache are not cleared even when R process
ends. Users need to clean the data by themselves. See
\code{\link{remove_session}} or \code{\link{remove_all_sessions}} about
removing session-based folders, or
\code{\link[raveio]{clear_cached_files}} to remove package-based cache.
}
\examples{

temp_dir()
temp_dir(persist = "package-cache")

}
