% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackoverflow.R
\name{stackoverflow}
\alias{stackoverflow}
\title{Retrieve raw R code from Stack Overflow website}
\usage{
stackoverflow(url, method, padding)
}
\arguments{
\item{url}{Link to a page on Stack Overflow website (or any Stack Exchange)}

\item{method}{Not all websites are formatted consistently. To overcome this, try a different
method by setting the method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
A character vector of length 1 containing the R code from the target url. All code
   at the target url (including javascript, ruby, python) will be returned.
}
\description{
Retrieve raw R code from Stack Overflow website
}
\examples{
library(dplyr)
stackoverflow("https://stackoverflow.com/questions/58248102/date-input-dt-r-shiny")

# Same as above but provided to cat for easy viewing
stackoverflow("https://stackoverflow.com/questions/58248102/date-input-dt-r-shiny") \%>\%
  cat


}
